function tinySetup(config)
{
	if(!config)
		config = {};

	//var editor_selector = 'rte';

	if (typeof config.editor_selector != 'undefined')
		config.selector = '.'+config.editor_selector;

	default_config = {
		selector: ".rte" ,
		plugins : "colorpicker link image paste pagebreak table contextmenu filemanager table code media autoresize textcolor anchor",
		browser_spellcheck : true,
		toolbar1 : "code,|,bold,italic,underline,strikethrough,|,alignleft,aligncenter,alignright,alignfull,formatselect,|,blockquote,colorpicker,pasteword,|,bullist,numlist,|,outdent,indent,|,link,unlink,|,anchor,|,media,image",
		toolbar2: "",
		external_filemanager_path: baseAdminDir+"filemanager/",
		filemanager_title: "File manager" ,
		external_plugins: { "filemanager" : baseAdminDir+"filemanager/plugin.min.js"},
		language: iso_user,
		skin: "prestashop",
		statusbar: false,
		relative_urls : false,
		convert_urls: false,
		entity_encoding: "raw",
		extended_valid_elements : "em[class|name|id]",
		valid_children : "+*[*]",
		valid_elements:"*[*]",
		menu: {
			edit: {title: 'Edit', items: 'undo redo | cut copy paste | selectall'},
			insert: {title: 'Insert', items: 'media image link | pagebreak'},
			view: {title: 'View', items: 'visualaid'},
			format: {title: 'Format', items: 'bold italic underline strikethrough superscript subscript | formats | removeformat'},
			table: {title: 'Table', items: 'inserttable tableprops deletetable | cell row column'},
			tools: {title: 'Tools', items: 'code'}
		}
	};

	$.each(default_config, function(index, el)
	{
		if (config[index] === undefined )
			config[index] = el;
	});

	tinyMCE.init(config);
}
