<?php
/**
 * 2007-2015 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2015 PrestaShop SA
 * @license   http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 * International Registered Trademark & Property of PrestaShop SA
 */

 use PrestaShop\PrestaShop\Core\Product\Search\ProductSearchQuery;
 use PrestaShop\PrestaShop\Core\Product\Search\SortOrder;
 use PrestaShop\PrestaShop\Adapter\Search\SearchProductSearchProvider;
 use PrestaShop\PrestaShop\Adapter\Translator;
 use PrestaShop\PrestaShop\Adapter\LegacyContext;

 class SearchControllerCore extends ProductListingFrontControllerCore
 {
     public $php_self = 'search';
     public $instant_search;
     public $ajax_search;

     private $search_string;
     private $search_tag;

    /**
     * Assign template vars related to page content
     * @see FrontController::initContent()
     */
    public function init()
    {
        parent::init();

        $this->search_string     = Tools::getValue('s');
        if (!$this->search_string) {
            $this->search_string = Tools::getValue('search_query');
        }

        $this->search_tag        = Tools::getValue('tag');

        $this->context->smarty->assign([
            'search_string' => $this->search_string,
            'search_tag'    => $this->search_tag
        ]);

        $this->doProductSearch('catalog/search.tpl');
    }

     protected function getProductSearchQuery()
     {
         $query = new ProductSearchQuery;
         $query
           ->setSortOrder(new SortOrder('product', 'position', 'asc'))
           ->setSearchString($this->search_string)
           ->setSearchTag($this->search_tag)
        ;
         return $query;
     }

     protected function getDefaultProductSearchProvider()
     {
         $translator = new Translator(new LegacyContext);
         return new SearchProductSearchProvider(
           $translator
       );
     }
 }
