<?php
/**
 * 2007-2015 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 *  @author 	PrestaShop SA <contact@prestashop.com>
 *  @copyright  2007-2015 PrestaShop SA
 *  @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 *  International Registered Trademark & Property of PrestaShop SA
 */

class Adapter_Database implements Core_Foundation_Database_DatabaseInterface
{
	/**
	 * Perform a SELECT sql statement
	 * @param $sqlString
	 * @return array|false
	 * @throws PrestaShopDatabaseException
	 */
	public function select($sqlString)
    {
        return Db::getInstance()->executeS($sqlString);
    }

	/**
	 * Escape $unsafe to be used into a SQL statement
	 * @param $unsafeData
	 * @return string
	 */
	public function escape($unsafeData)
    {
        $html_ok = true;
        return Db::getInstance()->escape($unsafeData, $html_ok);
    }
}
