<?php
/*
* 2007-2012 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Open Software License (OSL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/osl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2012 PrestaShop SA
*  @version  Release: $Revision: 17889 $
*  @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

/**
 * @since 1.5.0
 */
abstract class ModuleAdminControllerCore extends AdminController
{
	/**
	 * @var Module
	 */
	public $module;
	
	public function __construct()
	{
		$this->controller_type = 'moduleadmin';
		
		parent::__construct();

		$tab = new Tab($this->id);
		if (!$tab->module)
			throw new PrestaShopException('Admin tab '.get_class($this).' is not a module tab');

		$this->module = Module::getInstanceByName($tab->module);
		if (!$this->module->id)
			throw new PrestaShopException("Module {$tab->module} not found");
	}

	public function createTemplate($tpl_name)
	{
		if (file_exists($this->getTemplatePath().$this->override_folder.$tpl_name) && $this->viewAccess())
			return $this->context->smarty->createTemplate($this->getTemplatePath().$this->override_folder.$tpl_name, $this->context->smarty);

		return parent::createTemplate($tpl_name);
	}

	/**
	 * Get path to back office templates for the module
	 *
	 * @return string
	 */
	public function getTemplatePath()
	{
		return _PS_MODULE_DIR_.$this->module->name.'/views/templates/admin/';
	}
}
