<?php
/*
* 2007-2011 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Open Software License (OSL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/osl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2011 PrestaShop SA
*  @version  Release: $Revision: 7040 $
*  @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/
header("Cache-Control: no-cache, must-revalidate"); // HTTP/1.1
header("Expires: Sat, 26 Jul 1997 05:00:00 GMT"); // Date dans le passé
if (!class_exists('ConfigurationTest',false))
	require_once(INSTALL_PATH.'/../classes/ConfigurationTest.php');

// Functions list to test with 'test_system'
$funcs = array('fopen', 'fclose', 'fread', 'fwrite', 'rename', 'file_exists', 'unlink', 'rmdir', 'mkdir', 'getcwd', 'chdir', 'chmod');

// Test list to execute (function/args)
$tests = array(
	'phpversion' => false,
	'upload' => false,
	'system' => $funcs,
	'gd' => false,
	'mysql_support' => false,
	'config_dir' => 'config',
	'cache_dir' => 'cache',
	'sitemap' => 'sitemap.xml',
	'log_dir' => 'log',
	'img_dir' => 'img',
	'mails_dir' => 'mails/',
	'module_dir' => 'modules/',
	'theme_lang_dir' => 'themes/prestashop/lang',
	'theme_cache_dir' => 'themes/prestashop/cache',
	'translations_dir' => 'translations',
	'customizable_products_dir' => 'upload',
	'virtual_products_dir' => 'download',
);
$tests_op = array(
	'fopen' => false,
	'register_globals' => false,
	'gz' => false,
	'mcrypt' => false,
	'magicquotes' => false,
	'dom' => false,
);

// Execute tests
$res = ConfigurationTest::check($tests);
$res_op = ConfigurationTest::check($tests_op);

$has_error = false;

// Building XML Tree...
echo '<config>'."\n";
	echo '<firsttime value="'.((isset($_GET['firsttime']) AND $_GET['firsttime'] == 1) ? 1 : 0).'" />'."\n";
	echo '<testList id="required">'."\n";
	foreach ($res AS $key => $line)
	{
		if ($line == 'fail') $has_error = true;
		echo '<test id="'.$key.'" result="'.$line.'"/>'."\n";
	}
	echo '</testList>'."\n";
	echo '<testList id="optional">'."\n";
	foreach ($res_op AS $key => $line)
	{
		if ($line == 'fail') $has_error = true;
		echo '<test id="'.$key.'" result="'.$line.'"/>'."\n";
	}
	echo '</testList>'."\n";
echo '</config>';


