<?php

if (!defined('_CAN_LOAD_FILES_'))
	exit;

class BlockWishList extends Module
{
	const INSTALL_SQL_FILE = 'install.sql';

    private $_html = '';
    private $_postErrors = array();

	public function __construct()
	{
		$this->name = 'blockwishlist';
		$this->tab = 'front_office_features';
		$this->version = 0.2;
		
		parent::__construct();
		
		$this->displayName = $this->l('Wishlist block');
		$this->description = $this->l('Adds a block containing the customer\'s wishlists');
	}
	
	public function install()
	{
		if (!file_exists(dirname(__FILE__).'/'.self::INSTALL_SQL_FILE))
			return (false);
		else if (!$sql = file_get_contents(dirname(__FILE__).'/'.self::INSTALL_SQL_FILE))
			return (false);
		$sql = str_replace(array('PREFIX_', 'ENGINE_TYPE'), array(_DB_PREFIX_, _MYSQL_ENGINE_), $sql);
		$sql = preg_split("/;\s*[\r\n]+/", $sql);
		foreach ($sql AS $query)
			if($query)
				if(!Db::getInstance()->Execute(trim($query)))
					return false;
		if (!parent::install() OR
						!$this->registerHook('rightColumn') OR
						!$this->registerHook('productActions') OR
						!$this->registerHook('cart') OR
						!$this->registerHook('customerAccount') OR
						!$this->registerHook('header') OR
						!$this->registerHook('adminCustomers')
					)
			return false;
		/* This hook is optional */
		$this->registerHook('myAccountBlock');
		return true;
	}
	
	public function uninstall()
	{
		return (
			Db::getInstance()->Execute('DROP TABLE '._DB_PREFIX_.'wishlist') AND
			Db::getInstance()->Execute('DROP TABLE '._DB_PREFIX_.'wishlist_email') AND
			Db::getInstance()->Execute('DROP TABLE '._DB_PREFIX_.'wishlist_product') AND
			Db::getInstance()->Execute('DROP TABLE '._DB_PREFIX_.'wishlist_product_cart') AND 
			parent::uninstall()
		);
	}

	public function getContent()
	{
		$this->_html = '<h2>'.$this->displayName.'</h2>';
		if (Tools::isSubmit('submitSettings'))
		{
			$activated = Tools::getValue('activated');
			if ($activated != 0 AND $activated != 1)
				$this->_html .= '<div class="alert error">'.$this->l('Activate module : Invalid choice.').'</div>';
			$this->_html .= '<div class="conf confirm"><img src="../img/admin/ok.gif" alt="'.$this->l('Confirmation').'" />'.$this->l('Settings updated').'</div>';
		}
		$this->_displayForm();
		return ($this->_html);
	}

	private function _displayForm()
	{
		$this->_displayFormView();
	}
	
	private function _displayFormView()
	{
		global $cookie;

		$customers = Customer::getCustomers();
		if (!sizeof($customers))
			return;
		$id_customer = (int)(Tools::getValue('id_customer'));
		if (!$id_customer)
			$id_customer = $customers[0]['id_customer'];
		$this->_html .= '<br />
		<form action="'.$_SERVER['REQUEST_URI'].'" method="post" id="listing">
			<fieldset>
				<legend><img src="'.$this->_path.'img/icon/package_go.png" alt="" title="" />'.$this->l('Listing').'</legend>

				<label>'.$this->l('Customers').'</label>
				<div class="margin-form">
					<select name="id_customer" onchange="$(\'#listing\').submit();">';
		foreach ($customers as $customer)
		{
			$this->_html .= '<option value="'.(int)($customer['id_customer']).'"';
			if ($customer['id_customer'] == $id_customer)
				$this->_html .= ' selected="selected"';
			$this->_html .= '>'.htmlentities($customer['firstname'], ENT_COMPAT, 'UTF-8').' '.htmlentities($customer['lastname'], ENT_COMPAT, 'UTF-8').'</option>';
		}
		$this->_html .= '
					</select>
				</div>';
		require_once(dirname(__FILE__).'/WishList.php');
		$wishlists = WishList::getByIdCustomer($id_customer);
		if (!sizeof($wishlists))
			return ($this->_html .= '</fieldset></form>');
		$id_wishlist = false;
		foreach ($wishlists AS $row)
			if ($row['id_wishlist'] == Tools::getValue('id_wishlist'))
			{
				$id_wishlist = (int)(Tools::getValue('id_wishlist'));
				break;
			}
		if (!$id_wishlist)
			$id_wishlist = $wishlists[0]['id_wishlist'];
		$this->_html .= '
				<label>'.$this->l('Wishlists').'</label>
				<div class="margin-form">
					<select name="id_wishlist" onchange="$(\'#listing\').submit();">';
		foreach ($wishlists as $wishlist)
		{
			$this->_html .= '<option value="'.(int)($wishlist['id_wishlist']).'"';
			if ($wishlist['id_wishlist'] == $id_wishlist)
			{
				$this->_html .= ' selected="selected"';
				$counter = $wishlist['counter'];
			}
			$this->_html .= '>'.htmlentities($wishlist['name'], ENT_COMPAT, 'UTF-8').'</option>';
		}
		$this->_html .= '
					</select>
				</div>';
		$this->_displayProducts((int)($id_wishlist));
		$this->_html .= 	'</fieldset>
		</form>';
	}
	
	public function hookHeader($params)
	{
		Tools::addCSS(($this->_path).'blockwishlist.css', 'all');
		return $this->display(__FILE__, 'blockwishlist-header.tpl');
	}

	public function hookRightColumn($params)
	{
		global $smarty, $errors;

		require_once(dirname(__FILE__).'/WishList.php');
		if ($params['cookie']->isLogged())
		{
			$wishlists = Wishlist::getByIdCustomer($params['cookie']->id_customer);
			if (empty($params['cookie']->id_wishlist) === true ||
				WishList::exists($params['cookie']->id_wishlist, $params['cookie']->id_customer) === false)
			{
				if (!sizeof($wishlists))
					$id_wishlist = false;
				else
				{
					$id_wishlist = (int)($wishlists[0]['id_wishlist']);
					$params['cookie']->id_wishlist = (int)($id_wishlist);
				}
			}
			else
				$id_wishlist = $params['cookie']->id_wishlist;
			$smarty->assign(array(
				'id_wishlist' => $id_wishlist,
				'isLogged' => true,
				'wishlist_products' => ($id_wishlist == false ? false : WishList::getProductByIdCustomer($id_wishlist, $params['cookie']->id_customer, $params['cookie']->id_lang, null, true)),
				'wishlists' => $wishlists,
				'ptoken' => Tools::getToken(false)));
		}
		else
			$smarty->assign(array('wishlist_products' => false, 'wishlists' => false));
		return ($this->display(__FILE__, 'blockwishlist.tpl'));
	}

	public function hookLeftColumn($params)
	{
		return $this->hookRightColumn($params);
	}

	public function hookProductActions($params)
	{
		global $smarty;
		
		$smarty->assign('id_product', (int)(Tools::getValue('id_product')));
		return ($this->display(__FILE__, 'blockwishlist-extra.tpl'));
	}
	
	public function hookCustomerAccount($params)
	{
		global $smarty;
		return $this->display(__FILE__, 'my-account.tpl');
	}
	
	public function hookMyAccountBlock($params)
	{
		return $this->hookCustomerAccount($params);
	}
	
	private function _displayProducts($id_wishlist)
	{
		global $cookie;
		include_once(dirname(__FILE__).'/WishList.php');
		
		$wishlist = new WishList((int)($id_wishlist));
		$products = WishList::getProductByIdCustomer((int)($id_wishlist), (int)($wishlist->id_customer), (int)($cookie->id_lang));
		for ($i = 0; $i < sizeof($products); ++$i)
		{
			$obj = new Product((int)($products[$i]['id_product']), false, (int)($cookie->id_lang));
			if (!Validate::isLoadedObject($obj))
				continue;
			else
			{
				$images = $obj->getImages((int)($cookie->id_lang));
				foreach ($images AS $k => $image)
				{
					if ($image['cover'])
					{
						$products[$i]['cover'] = $obj->id.'-'.$image['id_image'];
						break;
					}
				}
				if (!isset($products[$i]['cover']))
					$products[$i]['cover'] = Language::getIsoById((int)($cookie->id_lang)).'-default';
			}
		}
		$this->_html .= '
		<table class="table">
			<thead>
				<tr>
					<th class="first_item" style="width:600px;">'.$this->l('Product').'</th>
					<th class="item" style="text-align:center;width:150px;">'.$this->l('Quantity').'</th>
					<th class="item" style="text-align:center;width:150px;">'.$this->l('Priority').'</th>
				</tr>
			</thead>
			<tbody>';
			$priority = array($this->l('High'), $this->l('Medium'), $this->l('Low'));
			foreach ($products as $product)
			{
				$this->_html .= '
				<tr>
					<td class="first_item">
						<img src="'._THEME_PROD_DIR_.$product['cover'].'-small.jpg" alt="'.htmlentities($product['name'], ENT_COMPAT, 'UTF-8').'" style="float:left;" />
						'.$product['name'];
				if (isset($product['attributes_small']))
					$this->_html .= '<br /><i>'.htmlentities($product['attributes_small'], ENT_COMPAT, 'UTF-8').'</i>';
				$this->_html .= '
					</td>
					<td class="item" style="text-align:center;">'.(int)($product['quantity']).'</td>
					<td class="item" style="text-align:center;">'.$priority[(int)($product['priority']) % 3].'</td>
				</tr>';
			}
		$this->_html .= '</tbody></table>';
	}
	
	public function hookAdminCustomers($params)
	{
		require_once(dirname(__FILE__).'/WishList.php');
		
		$customer = new Customer((int)($params['id_customer']));
		if (!Validate::isLoadedObject($customer))
			die (Tools::displayError());

		$this->_html = '<h2>'.$this->l('Wishlists').'</h2>';
		
		$wishlists = WishList::getByIdCustomer((int)($customer->id));
		if (!sizeof($wishlists))
			$this->_html .= $customer->lastname.' '.$customer->firstname.' '.$this->l('had no wishlist');
		else
		{
			$this->_html .= '<form action="'.$_SERVER['REQUEST_URI'].'" method="post" id="listing">';
	
			$id_wishlist = (int)(Tools::getValue('id_wishlist'));
			if (!$id_wishlist)
					$id_wishlist = $wishlists[0]['id_wishlist'];
			
			$this->_html .= '<span>'.$this->l('Wishlist').': </span> <select name="id_wishlist" onchange="$(\'#listing\').submit();">';
			foreach ($wishlists as $wishlist)
			{
				$this->_html .= '<option value="'.(int)($wishlist['id_wishlist']).'"';
				if ($wishlist['id_wishlist'] == $id_wishlist)
				{
					$this->_html .= ' selected="selected"';
					$counter = $wishlist['counter'];
				}
				$this->_html .= '>'.htmlentities($wishlist['name'], ENT_COMPAT, 'UTF-8').'</option>';
			}		
			$this->_html .= '</select>';
			
			$this->_displayProducts((int)($id_wishlist));
						
			$this->_html .= '</form><br />';
			
			return $this->_html;
		}
	}
	/*
	* Display Error from controler
	*/
	public function errorLogged()
	{
		return $this->l('You need to be logged to manage your wishlist');
	}
}
?>
