SET NAMES 'utf8';

INSERT INTO `PREFIX_hook` (`id_hook`, `name`, `title`, `description`, `position`) VALUES
(1, 'payment', 'Payment', NULL, 1),
(2, 'newOrder', 'New orders', NULL, 0),
(3, 'paymentConfirm', 'Payment confirmation', NULL, 0),
(4, 'paymentReturn', 'Payment return', NULL, 0),
(5, 'updateQuantity', 'Quantity update', 'Quantity is updated only when the customer effectively <b>place</b> his order.', 0),
(6, 'rightColumn', 'Right column blocks', NULL, 1),
(7, 'leftColumn', 'Left column blocks', NULL, 1),
(8, 'home', 'Homepage content', NULL, 1),
(9, 'header', 'Header of pages', 'A hook which allow you to do things in the header of each pages', 1),
(10, 'cart', 'Cart creation and update', NULL, 0),
(11, 'authentication', 'Successful customer authentication', NULL, 0),
(12, 'addproduct', 'Product creation', NULL, 0),
(13, 'updateproduct', 'Product Update', NULL, 0),
(14, 'top', 'Top of pages', 'A hook which allow you to do things a the top of each pages.', 1),
(15, 'extraRight', 'Extra actions on the product page (right column).', NULL, 0),
(16, 'deleteproduct', 'Product deletion', 'This hook is called when a product is deleted', 0),
(17, 'productfooter', 'Product footer', 'Add new blocks under the product description', 1),
(18, 'invoice', 'Invoice', 'Add blocks to invoice (order)', 1),
(19, 'updateOrderStatus', 'Order''s status update event', 'Launch modules when the order''s status of an order change.', 0),
(20, 'adminOrder', 'Display in Back-Office, tab AdminOrder', 'Launch modules when the tab AdminOrder is displayed on back-office.', 0),
(21, 'footer', 'Footer', 'Add block in footer', 1),
(22, 'PDFInvoice', 'PDF Invoice', 'Allow the display of extra informations into the PDF invoice', 0),
(23, 'adminCustomers', 'Display in Back-Office, tab AdminCustomers', 'Launch modules when the tab AdminCustomers is displayed on back-office.', 0),
(24, 'orderConfirmation', 'Order confirmation page', 'Called on order confirmation page', 0),
(25, 'createAccount', 'Successful customer create account', 'Called when new customer create account successfuled', 0),
(26, 'customerAccount', 'Customer account page display in front office', 'Display on page account of the customer', 1),
(27, 'orderSlip', 'Called when a order slip is created', 'Called when a quantity of one product change in an order.', 0),
(28, 'productTab', 'Tabs on product page', 'Called on order product page tabs', 0),
(29, 'productTabContent', 'Content of tabs on product page', 'Called on order product page tabs', 0),
(30, 'shoppingCart', 'Shopping cart footer', 'Display some specific informations on the shopping cart page', 0),
(31, 'createAccountForm', 'Customer account creation form', 'Display some information on the form to create a customer account', 1),
(32, 'AdminStatsModules','Stats - Modules', NULL, 1),
(33, 'GraphEngine','Graph Engines', NULL, 0),
(34, 'orderReturn','Product returned', NULL, 0),
(35, 'productActions', 'Product actions', 'Put new action buttons on product page', 1),
(36, 'backOfficeHome', 'Administration panel homepage', NULL, 1),
(37, 'GridEngine','Grid Engines', NULL, 0),
(38, 'watermark','Watermark', NULL, 0),
(39, 'cancelProduct', 'Product cancelled', 'This hook is called when you cancel a product in an order', 0),
(40, 'extraLeft', 'Extra actions on the product page (left column).', NULL, 0),
(41, 'productOutOfStock', 'Product out of stock', 'Make action while product is out of stock', 1),
(42, 'updateProductAttribute', 'Product attribute update', NULL, 0),
(43, 'extraCarrier', 'Extra carrier (module mode)', NULL, 0),
(44, 'shoppingCartExtra', 'Shopping cart extra button', 'Display some specific informations', 1),
(45, 'search', 'Search', NULL, 0),
(46, 'backBeforePayment', 'Redirect in order process', 'Redirect user to the module instead of displaying payment modules', 0),
(47, 'updateCarrier', 'Carrier Update', 'This hook is called when a carrier is updated', 0),
(48, 'postUpdateOrderStatus', 'Post update of order status', NULL, 0),
(49, 'createAccountTop', 'Block above the form for create an account', NULL, 1),
(50, 'backOfficeHeader', 'Administration panel header', NULL , 0),
(51, 'backOfficeTop', 'Administration panel hover the tabs', NULL , 1),
(52, 'backOfficeFooter', 'Administration panel footer', NULL , 1),
(53, 'deleteProductAttribute', 'Product Attribute Deletion', NULL, 0),
(54, 'processCarrier', 'Carrier Process', NULL, 0),
(55, 'orderDetail', 'Order Detail', 'To set the follow-up in smarty when order detail is called', 0),
(56, 'beforeCarrier', 'Before carrier list', 'This hook is display before the carrier list on Front office', 1),
(57, 'orderDetailDisplayed', 'Order detail displayed', 'Displayed on order detail on front office', 1),
(58, 'paymentCCAdded', 'Payment CC added', 'Payment CC added', '0'),
(59, 'extraProductComparison', 'Extra Product Comparison', 'Extra Product Comparison', '0'),
(60, 'categoryAddition', 'Category creation', '', 0),
(61, 'categoryUpdate', 'Category modification', '', 0),
(62, 'categoryDeletion', 'Category removal', '', 0),
(63, 'beforeAuthentication', 'Before Authentication', 'Before authentication', 0),
(64, 'paymentTop', 'Top of payment page', 'Top of payment page', 0)
;

INSERT INTO `PREFIX_configuration` (`id_configuration`, `name`, `value`, `date_add`, `date_upd`) VALUES
(1, 'PS_LANG_DEFAULT', '1', NOW(), NOW()),
(2, 'PS_CURRENCY_DEFAULT', '1', NOW(), NOW()),
(3, 'PS_COUNTRY_DEFAULT', '8', NOW(), NOW()),
(4, 'PS_REWRITING_SETTINGS', '0', NOW(), NOW()),
(5, 'PS_ORDER_OUT_OF_STOCK', '0', NOW(), NOW()),
(6, 'PS_LAST_QTIES', '3', NOW(), NOW()),
(7, 'PS_CART_REDIRECT', '1', NOW(), NOW()),
(8, 'PS_HELPBOX', '1', NOW(), NOW()),
(9, 'PS_CONDITIONS', '1', NOW(), NOW()),
(10, 'PS_RECYCLABLE_PACK', '1', NOW(), NOW()),
(11, 'PS_GIFT_WRAPPING', '1', NOW(), NOW()),
(12, 'PS_GIFT_WRAPPING_PRICE', '0', NOW(), NOW()),
(13, 'PS_STOCK_MANAGEMENT', '1', NOW(), NOW()),
(14, 'PS_NAVIGATION_PIPE', '>', NOW(), NOW()),
(15, 'PS_PRODUCTS_PER_PAGE', '10', NOW(), NOW()),
(16, 'PS_PURCHASE_MINIMUM', '0', NOW(), NOW()),
(17, 'PS_PRODUCTS_ORDER_WAY', '0', NOW(), NOW()),
(18, 'PS_PRODUCTS_ORDER_BY', '4', NOW(), NOW()),
(19, 'PS_DISPLAY_QTIES', '1', NOW(), NOW()),
(20, 'PS_SHIPPING_HANDLING', '2', NOW(), NOW()),
(21, 'PS_SHIPPING_FREE_PRICE', '300', NOW(), NOW()),
(22, 'PS_SHIPPING_FREE_WEIGHT', '20', NOW(), NOW()),
(23, 'PS_SHIPPING_METHOD', '1', NOW(), NOW()),
(24, 'PS_TAX', '1', NOW(), NOW()),
(25, 'PS_SHOP_ENABLE', '1', NOW(), NOW()),
(26, 'PS_NB_DAYS_NEW_PRODUCT', '20', NOW(), NOW()),
(27, 'PS_SSL_ENABLED', '0', NOW(), NOW()),
(28, 'PS_WEIGHT_UNIT', 'kg', NOW(), NOW()),
(29, 'PS_BLOCK_CART_AJAX', '1', NOW(), NOW()),
(30, 'PS_ORDER_RETURN', '0', NOW(), NOW()),
(31, 'PS_ORDER_RETURN_NB_DAYS', '7', NOW(), NOW()),
(32, 'PS_MAIL_TYPE', '3', NOW(), NOW()),
(33, 'PS_PRODUCT_PICTURE_MAX_SIZE', '131072', NOW(), NOW()),
(34, 'PS_PRODUCT_PICTURE_WIDTH', '64', NOW(), NOW()),
(35, 'PS_PRODUCT_PICTURE_HEIGHT', '64', NOW(), NOW()),
(36, 'PS_INVOICE_PREFIX', 'IN', NOW(), NOW()),
(37, 'PS_INVOICE_NUMBER', '1', NOW(), NOW()),
(38, 'PS_DELIVERY_PREFIX', 'DE', NOW(), NOW()),
(39, 'PS_DELIVERY_NUMBER', '1', NOW(), NOW()),
(40, 'PS_INVOICE', '1', NOW(), NOW()),
(41, 'PS_PASSWD_TIME_BACK', '360', NOW(), NOW()),
(42, 'PS_PASSWD_TIME_FRONT', '360', NOW(), NOW()),
(43, 'PS_DISP_UNAVAILABLE_ATTR', '1', NOW(), NOW()),
(44, 'PS_VOUCHERS', '1', NOW(), NOW()),
(45, 'PS_SEARCH_MINWORDLEN', '3', NOW(), NOW()),
(46, 'PS_SEARCH_BLACKLIST', '', NOW(), NOW()),
(47, 'PS_SEARCH_WEIGHT_PNAME', '6', NOW(), NOW()),
(48, 'PS_SEARCH_WEIGHT_REF', '10', NOW(), NOW()),
(49, 'PS_SEARCH_WEIGHT_SHORTDESC', '1', NOW(), NOW()),
(50, 'PS_SEARCH_WEIGHT_DESC', '1', NOW(), NOW()),
(51, 'PS_SEARCH_WEIGHT_CNAME', '3', NOW(), NOW()),
(52, 'PS_SEARCH_WEIGHT_MNAME', '3', NOW(), NOW()),
(53, 'PS_SEARCH_WEIGHT_TAG', '4', NOW(), NOW()),
(54, 'PS_SEARCH_WEIGHT_ATTRIBUTE', '2', NOW(), NOW()),
(55, 'PS_SEARCH_WEIGHT_FEATURE', '2', NOW(), NOW()),
(56, 'PS_SEARCH_AJAX', '1', NOW(), NOW()),
(57, 'PS_TIMEZONE', 'Europe/Paris', NOW(), NOW()),
(58, 'PS_THEME_V11', 0, NOW(), NOW()),
(59, 'PRESTASTORE_LIVE', 1, NOW(), NOW()),
(60, 'PS_TIN_ACTIVE', 0, NOW(), NOW()),
(61, 'PS_SHOW_ALL_MODULES', 0, NOW(), NOW()),
(62, 'PS_BACKUP_ALL', 0, NOW(), NOW()),
(63, 'PS_1_3_UPDATE_DATE', NOW(), NOW(), NOW()),
(64, 'PS_PRICE_ROUND_MODE', 2, NOW(), NOW()),
(65, 'PS_1_3_2_UPDATE_DATE', NOW(), NOW(), NOW()),
(66, 'PS_CONDITIONS_CMS_ID', 3, NOW(), NOW()),
(67, 'TRACKING_DIRECT_TRAFFIC', 0, NOW(), NOW()),
(68, 'PS_META_KEYWORDS', 0, NOW(), NOW()),
(69, 'PS_DISPLAY_JQZOOM', 0, NOW(), NOW()),
(70, 'PS_VOLUME_UNIT', 'cl', NOW(), NOW()),
(71, 'PS_CIPHER_ALGORITHM', 0, NOW(), NOW()),
(72, 'PS_ATTRIBUTE_CATEGORY_DISPLAY', 1, NOW(), NOW()),
(73, 'PS_CUSTOMER_SERVICE_FILE_UPLOAD', 1, NOW(), NOW()),
(74, 'PS_CUSTOMER_SERVICE_SIGNATURE', '', NOW(), NOW()),
(75, 'PS_BLOCK_BESTSELLERS_DISPLAY', 0, NOW(), NOW()),
(76, 'PS_BLOCK_NEWPRODUCTS_DISPLAY', 0, NOW(), NOW()),
(77, 'PS_BLOCK_SPECIALS_DISPLAY', 0, NOW(), NOW()),
(78, 'PS_STOCK_MVT_REASON_DEFAULT', 3, NOW(), NOW()),
(79, 'PS_COMPARATOR_MAX_ITEM', 3, NOW(), NOW()),
(80, 'PS_ORDER_PROCESS_TYPE', 0, NOW(), NOW()),
(81, 'PS_SPECIFIC_PRICE_PRIORITIES', 'id_shop;id_currency;id_country;id_group', NOW(), NOW()),
(82, 'PS_TAX_DISPLAY', 0, NOW(), NOW()),
(83, 'PS_SMARTY_FORCE_COMPILE', 0, NOW(), NOW()),
(84, 'PS_DISTANCE_UNIT', 'km', NOW(), NOW()),
(85, 'PS_STORES_DISPLAY_CMS', 1, NOW(), NOW()),
(86, 'PS_STORES_DISPLAY_FOOTER', 1, NOW(), NOW()),
(87, 'PS_STORES_SIMPLIFIED', 0, NOW(), NOW()),
(88, 'SHOP_LOGO_WIDTH', 224, NOW(), NOW()),
(89, 'SHOP_LOGO_HEIGHT', 73, NOW(), NOW()),
(90, 'EDITORIAL_IMAGE_WIDTH', 530, NOW(), NOW()),
(91, 'EDITORIAL_IMAGE_HEIGHT', 228, NOW(), NOW()),
(92, 'PS_STATSDATA_CUSTOMER_PAGESVIEWS', 0, NOW(), NOW()),
(93, 'PS_STATSDATA_PAGESVIEWS', 0, NOW(), NOW()),
(94, 'PS_STATSDATA_PLUGINS', 0, NOW(), NOW()),
(95, 'PS_GEOLOCALIZATION_ENABLED', '0', NOW(), NOW()),
(96, 'PS_ALLOWED_COUNTRIES', 'AF;ZA;AX;AL;DZ;DE;AD;AO;AI;AQ;AG;AN;SA;AR;AM;AW;AU;AT;AZ;BS;BH;BD;BB;BY;BE;BZ;BJ;BM;BT;BO;BA;BW;BV;BR;BN;BG;BF;MM;BI;KY;KH;CM;CA;CV;CF;CL;CN;CX;CY;CC;CO;KM;CG;CD;CK;KR;KP;CR;CI;HR;CU;DK;DJ;DM;EG;IE;SV;AE;EC;ER;ES;EE;ET;FK;FO;FJ;FI;FR;GA;GM;GE;GS;GH;GI;GR;GD;GL;GP;GU;GT;GG;GN;GQ;GW;GY;GF;HT;HM;HN;HK;HU;IM;MU;VG;VI;IN;ID;IR;IQ;IS;IL;IT;JM;JP;JE;JO;KZ;KE;KG;KI;KW;LA;LS;LV;LB;LR;LY;LI;LT;LU;MO;MK;MG;MY;MW;MV;ML;MT;MP;MA;MH;MQ;MR;YT;MX;FM;MD;MC;MN;ME;MS;MZ;NA;NR;NP;NI;NE;NG;NU;NF;NO;NC;NZ;IO;OM;UG;UZ;PK;PW;PS;PA;PG;PY;NL;PE;PH;PN;PL;PF;PR;PT;QA;DO;CZ;RE;RO;UK;RU;RW;EH;BL;KN;SM;MF;PM;VA;VC;LC;SB;WS;AS;ST;SN;RS;SC;SL;SG;SK;SI;SO;SD;LK;SE;CH;SR;SJ;SZ;SY;TJ;TW;TZ;TD;TF;TH;TL;TG;TK;TO;TT;TN;TM;TC;TR;TV;UA;UY;US;VU;VE;VN;WF;YE;ZM;ZW', NOW(), NOW()),
(97, 'PS_GEOLOCALIZATION_BEHAVIOR', '0', NOW(), NOW()),
(98, 'PS_LOCALE_LANGUAGE', '', NOW(), NOW()),
(99, 'PS_LOCALE_COUNTRY', '', NOW(), NOW()),
(100, 'PS_ATTACHMENT_MAXIMUM_SIZE', '2', NOW(), NOW()),
(101, 'PS_SMARTY_CACHE', '1', NOW(), NOW()),
(102, 'PS_DIMENSION_UNIT', 'cm', NOW(), NOW()),
(103, 'PS_FORCE_SMARTY_2', '0', NOW(), NOW()),
(104, 'PS_GUEST_CHECKOUT_ENABLED', '0', NOW(), NOW()),
(105, 'PS_DISPLAY_SUPPLIERS', '0', NOW(), NOW()),
(106, 'PS_CATALOG_MODE', '0', NOW(), NOW()),
(107, 'PS_GEOLOCALIZATION_WHITELIST', '209.185.108;209.185.253;209.85.238;209.85.238.11;209.85.238.4;216.239.33.96;216.239.33.97;216.239.33.98;216.239.33.99;216.239.37.98;216.239.37.99;216.239.39.98;216.239.39.99;216.239.41.96;216.239.41.97;216.239.41.98;216.239.41.99;216.239.45.4;216.239.46;216.239.51.96;216.239.51.97;216.239.51.98;216.239.51.99;216.239.53.98;216.239.53.99;216.239.57.96;216.239.57.97;216.239.57.98;216.239.57.99;216.239.59.98;216.239.59.99;216.33.229.163;64.233.173.193;64.233.173.194;64.233.173.195;64.233.173.196;64.233.173.197;64.233.173.198;64.233.173.199;64.233.173.200;64.233.173.201;64.233.173.202;64.233.173.203;64.233.173.204;64.233.173.205;64.233.173.206;64.233.173.207;64.233.173.208;64.233.173.209;64.233.173.210;64.233.173.211;64.233.173.212;64.233.173.213;64.233.173.214;64.233.173.215;64.233.173.216;64.233.173.217;64.233.173.218;64.233.173.219;64.233.173.220;64.233.173.221;64.233.173.222;64.233.173.223;64.233.173.224;64.233.173.225;64.233.173.226;64.233.173.227;64.233.173.228;64.233.173.229;64.233.173.230;64.233.173.231;64.233.173.232;64.233.173.233;64.233.173.234;64.233.173.235;64.233.173.236;64.233.173.237;64.233.173.238;64.233.173.239;64.233.173.240;64.233.173.241;64.233.173.242;64.233.173.243;64.233.173.244;64.233.173.245;64.233.173.246;64.233.173.247;64.233.173.248;64.233.173.249;64.233.173.250;64.233.173.251;64.233.173.252;64.233.173.253;64.233.173.254;64.233.173.255;64.68.80;64.68.81;64.68.82;64.68.83;64.68.84;64.68.85;64.68.86;64.68.87;64.68.88;64.68.89;64.68.90.1;64.68.90.10;64.68.90.11;64.68.90.12;64.68.90.129;64.68.90.13;64.68.90.130;64.68.90.131;64.68.90.132;64.68.90.133;64.68.90.134;64.68.90.135;64.68.90.136;64.68.90.137;64.68.90.138;64.68.90.139;64.68.90.14;64.68.90.140;64.68.90.141;64.68.90.142;64.68.90.143;64.68.90.144;64.68.90.145;64.68.90.146;64.68.90.147;64.68.90.148;64.68.90.149;64.68.90.15;64.68.90.150;64.68.90.151;64.68.90.152;64.68.90.153;64.68.90.154;64.68.90.155;64.68.90.156;64.68.90.157;64.68.90.158;64.68.90.159;64.68.90.16;64.68.90.160;64.68.90.161;64.68.90.162;64.68.90.163;64.68.90.164;64.68.90.165;64.68.90.166;64.68.90.167;64.68.90.168;64.68.90.169;64.68.90.17;64.68.90.170;64.68.90.171;64.68.90.172;64.68.90.173;64.68.90.174;64.68.90.175;64.68.90.176;64.68.90.177;64.68.90.178;64.68.90.179;64.68.90.18;64.68.90.180;64.68.90.181;64.68.90.182;64.68.90.183;64.68.90.184;64.68.90.185;64.68.90.186;64.68.90.187;64.68.90.188;64.68.90.189;64.68.90.19;64.68.90.190;64.68.90.191;64.68.90.192;64.68.90.193;64.68.90.194;64.68.90.195;64.68.90.196;64.68.90.197;64.68.90.198;64.68.90.199;64.68.90.2;64.68.90.20;64.68.90.200;64.68.90.201;64.68.90.202;64.68.90.203;64.68.90.204;64.68.90.205;64.68.90.206;64.68.90.207;64.68.90.208;64.68.90.21;64.68.90.22;64.68.90.23;64.68.90.24;64.68.90.25;64.68.90.26;64.68.90.27;64.68.90.28;64.68.90.29;64.68.90.3;64.68.90.30;64.68.90.31;64.68.90.32;64.68.90.33;64.68.90.34;64.68.90.35;64.68.90.36;64.68.90.37;64.68.90.38;64.68.90.39;64.68.90.4;64.68.90.40;64.68.90.41;64.68.90.42;64.68.90.43;64.68.90.44;64.68.90.45;64.68.90.46;64.68.90.47;64.68.90.48;64.68.90.49;64.68.90.5;64.68.90.50;64.68.90.51;64.68.90.52;64.68.90.53;64.68.90.54;64.68.90.55;64.68.90.56;64.68.90.57;64.68.90.58;64.68.90.59;64.68.90.6;64.68.90.60;64.68.90.61;64.68.90.62;64.68.90.63;64.68.90.64;64.68.90.65;64.68.90.66;64.68.90.67;64.68.90.68;64.68.90.69;64.68.90.7;64.68.90.70;64.68.90.71;64.68.90.72;64.68.90.73;64.68.90.74;64.68.90.75;64.68.90.76;64.68.90.77;64.68.90.78;64.68.90.79;64.68.90.8;64.68.90.80;64.68.90.9;64.68.91;64.68.92;66.249.64;66.249.65;66.249.66;66.249.67;66.249.68;66.249.69;66.249.70;66.249.71;66.249.72;66.249.73;66.249.78;66.249.79;72.14.199;8.6.48', NOW(), NOW()),
(108, 'PS_LOGS_BY_EMAIL', '5', NOW(), NOW()),
(109, 'PS_COOKIE_CHECKIP', '1', NOW(), NOW()),
(110, 'PS_STORES_CENTER_LAT', '25.948969', NOW(), NOW()),
(111, 'PS_STORES_CENTER_LONG', '-80.226439', NOW(), NOW());


INSERT INTO `PREFIX_configuration_lang` (`id_configuration`, `id_lang`, `value`, `date_upd`) VALUES
(36, 1, 'IN', NOW()),(36, 2, 'FA', NOW()),(36, 3, 'CU', NOW()),(36, 4, 'FA', NOW()),(36, 5, 'FA', NOW()),
(38, 1, 'DE', NOW()),(38, 2, 'LI', NOW()),(38, 3, 'EN', NOW()),(38, 4, 'LI', NOW()),(38, 5, 'BC', NOW()),
(46, 1, 'a|the|of|on|in|and|to', NOW()),(46, 2, 'le|les|de|et|en|des|les|une', NOW()),(46, 3, 'de|los|las|lo|la|en|de|y|el|a', NOW()),(46, 4, '', NOW()),(46, 5, '', NOW()),
(68, 1, 0, NOW()),(68, 2, 0, NOW()),(68, 3, 0, NOW()),(68, 4, 0, NOW()),(68, 5, 0, NOW()),
(74, 1, 'Dear Customer,\r\n\r\nRegards,\r\nCustomer service', NOW()),
(74, 2, 'Cher client,\r\n\r\nCordialement,\r\nLe service client', NOW()),
(74, 3, 'Estimado cliente,\r\n\r\nUn cordial saludo,\r\nAtención al cliente', NOW()),
(74, 4, 'Lieber Kunde,\r\n\r\nMit freundlichen Grüßen,\r\nIhr Kundenservice', NOW()),
(74, 5, 'Gentile Cliente,\r\n\r\nCordiali saluti,\r\nServizio Clienti', NOW());

INSERT INTO `PREFIX_lang` (`id_lang`, `name`, `active`, `iso_code`, `language_code`) VALUES
(1, 'English (English)', 1, 'en', 'en-us'),(2, 'Français (French)', 1, 'fr', 'fr'),(3, 'Español (Spanish)', 1, 'es', 'es'),(4, 'Deutsch (German)', 1, 'de', 'de'),(5, 'Italiano (Italian)', 1, 'it', 'it');

INSERT INTO `PREFIX_category` (`id_category`, `id_parent`, `level_depth`, `nleft`, `nright`, `active`, `date_add`, `date_upd`, `position`) VALUES (1, 0, 0, 1, 8, 1, NOW(), NOW(), 0);
INSERT INTO `PREFIX_category_lang` (`id_category`, `id_lang`, `name`, `description`, `link_rewrite`, `meta_title`, `meta_keywords`, `meta_description`) VALUES
(1, 1, 'Home', '', 'home', NULL, NULL, NULL),(1, 2, 'Accueil', '', 'home', NULL, NULL, NULL),(1, 3, 'Inicio', '', 'home', NULL, NULL, NULL),(1, 4, 'Start', '', 'home', NULL, NULL, NULL),(1, 5, 'Home page', '', 'home', NULL, NULL, NULL);

INSERT INTO `PREFIX_order_state` (`id_order_state`, `invoice`, `send_email`, `color`, `unremovable`, `logable`, `delivery`) VALUES
(1, 0, 1, 'lightblue', 1, 0, 0),(2, 1, 1, '#DDEEFF', 1, 1, 0),(3, 1, 1, '#FFDD99', 1, 1, 1),(4, 1, 1, '#EEDDFF', 1, 1, 1),(5, 1, 0, '#DDFFAA', 1, 1, 1),
(6, 0, 1, '#DADADA', 1, 0, 0),(7, 1, 1, '#FFFFBB', 1, 0, 0),(8, 0, 1, '#FFDFDF', 1, 0, 0),(9, 1, 1, '#FFD3D3', 1, 0, 0),(10, 0, 1, 'lightblue', 1, 0, 0),(11, 0, 0, 'lightblue', 1, 0, 0);

INSERT INTO `PREFIX_order_state_lang` (`id_order_state`, `id_lang`, `name`, `template`) VALUES
(1, 1, 'Awaiting cheque payment', 'cheque'),
(2, 1, 'Payment accepted', 'payment'),
(3, 1, 'Preparation in progress', 'preparation'),
(4, 1, 'Shipped', 'shipped'),
(5, 1, 'Delivered', ''),
(6, 1, 'Canceled', 'order_canceled'),
(7, 1, 'Refund', 'refund'),
(8, 1, 'Payment error', 'payment_error'),
(9, 1, 'On backorder', 'outofstock'),
(10, 1, 'Awaiting bank wire payment', 'bankwire'),
(11, 1, 'Awaiting PayPal payment', ''),
(1, 2, 'En attente du paiement par chèque', 'cheque'),
(2, 2, 'Paiement accepté', 'payment'),
(3, 2, 'Préparation en cours', 'preparation'),
(4, 2, 'En cours de livraison', 'shipped'),
(5, 2, 'Livré', ''),
(6, 2, 'Annulé', 'order_canceled'),
(7, 2, 'Remboursé', 'refund'),
(8, 2, 'Erreur de paiement', 'payment_error'),
(9, 2, 'En attente de réapprovisionnement', 'outofstock'),
(10, 2, 'En attente du paiement par virement bancaire', 'bankwire'),
(11, 2, 'En attente du paiement par PayPal', ''),
(1, 3, 'En espera de pago por cheque', 'cheque'),
(2, 3, 'Pago aceptamos', 'payment'),
(3, 3, 'Preparación en curso', 'preparation'),
(4, 3, 'Enviado', 'shipped'),
(5, 3, 'Entregado', ''),
(6, 3, 'Cancelada', 'order_canceled'),
(7, 3, 'Reembolsado', 'refund'),
(8, 3, 'Error de pago', 'payment_error'),
(9, 3, 'Productos fuera de línea', 'outofstock'),
(10, 3, 'En espera de pago por transferencia bancaria', 'bankwire'),
(11, 3, 'En espera de pago por PayPal', ''),
(1, 4, 'Scheckzahlung wird erwartet', 'cheque'),
(2, 4, 'Zahlung angenommen', 'payment'),
(3, 4, 'Vorbereitung im Gang', 'preparation'),
(4, 4, 'Wird geliefert', 'shipped'),
(5, 4, 'Geliefert', ''),
(6, 4, 'Abgebrochen', 'order_canceled'),
(7, 4, 'Erstattet', 'refund'),
(8, 4, 'Zahlungsfehler', 'payment_error'),
(9, 4, 'Auffüllung im Gang', 'outofstock'),
(10, 4, 'Zahlung durch Banküberweisung wird erwartet', 'bankwire'),
(11, 4, 'Zahlung per PayPal wird erwartet', ''),
(1, 5, 'In attesa di pagamento con assegno', 'cheque'),
(2, 5, 'Pagamento accettato', 'payment'),
(3, 5, 'Preparazione in corso', 'preparation'),
(4, 5, 'Consegna in corso', 'shipped'),
(5, 5, 'Consegnato', ''),
(6, 5, 'Annullato', 'order_canceled'),
(7, 5, 'Rimborsato', 'refund'),
(8, 5, 'Errore di pagamento', 'payment_error'),
(9, 5, 'In attesa di rifornimento', 'outofstock'),
(10, 5, 'In attesa di pagamento con bonifico bancario', 'bankwire'),
(11, 5, 'In attesa di pagamento con PayPal', '');

INSERT INTO `PREFIX_zone` (`id_zone`, `name`, `active`) VALUES
(1, 'Europe', 1),(2, 'North America', 1),(3, 'Asia', 1),(4, 'Africa', 1),
(5, 'Oceania', 1),(6, 'South America', 1),(7, 'Europe (out E.U)', 1),(8, 'Centrale America/Antilla', 1);

INSERT INTO `PREFIX_country` (`id_country`, `id_zone`, `iso_code`, `call_prefix`, `active`, `contains_states`, `need_identification_number`, `need_zip_code`, `zip_code_format`) VALUES
(1, 1, 'DE', 49, 1, 0, 0, 1, 'NNNNN'),(2, 1, 'AT', 43, 1, 0, 0, 1, 'NNNN'),(3, 1, 'BE', 32, 1, 0, 0, 1, 'NNNN'),(4, 2, 'CA', 1, 1, 1, 0, 1, 'LNL NLN'),(5, 3, 'CN', 86, 1, 0, 0, 1, 'NNNNNN'),
(6, 1, 'ES', 34, 1, 0, 1, 1, 'NNNNN'),(7, 1, 'FI', 358, 1, 0, 0, 1, 'NNNNN'),(8, 1, 'FR', 33, 1, 0, 0, 1, 'NNNNN'),(9, 1, 'GR', 30, 1, 0, 0, 1, 'NNNNN'),(10, 1, 'IT', 39, 1, 1, 0, 1, 'NNNNN'),
(11, 3, 'JP', 81, 1, 0, 0, 1, 'NNN-NNNN'),(12, 1, 'LU', 352, 1, 0, 0, 1, 'NNNN'),(13, 1, 'NL', 31, 1, 0, 0, 1, 'NNNN LL'),(14, 1, 'PL', 48, 1, 0, 0, 1, 'NN-NNN'),
(15, 1, 'PT', 351, 1, 0, 0, 1, 'NNNN NNN'),(16, 1, 'CZ', 420, 1, 0, 0, 1, 'NNN NN'),(17, 1, 'UK', 44, 1, 0, 0, 1, ''),(18, 1, 'SE', 46, 1, 0, 0, 1, 'NNN NN'),
(19, 7, 'CH', 41, 1, 0, 0, 1, 'NNNN'),(20, 1, 'DK', 45, 1, 0, 0, 1, 'NNNN'),(21, 2, 'US', 1, 1, 1, 0, 1, 'NNNNN'),(22, 3, 'HK', 852, 1, 0, 0, 0, ''),(23, 1, 'NO', 47, 1, 0, 0, 1, 'NNNN'),
(24, 5, 'AU', 61, 1, 0, 0, 1, 'NNNN'),(25, 3, 'SG', 65, 1, 0, 0, 1, 'NNNNNN'),(26, 1, 'IE', 353, 1, 0, 0, 1, ''),(27, 5, 'NZ', 64, 1, 0, 0, 1, 'NNNN'),(28, 3, 'KR', 82, 1, 0, 0, 1, 'NNN-NNN'),
(29, 3, 'IL', 972, 1, 0, 0, 1, 'NNNNN'),(30, 4, 'ZA', 27, 1, 0, 0, 1, 'NNNN'),(31, 4, 'NG', 234, 1, 0, 0, 1, ''),(32, 4, 'CI', 225, 1, 0, 0, 1, ''),(33, 4, 'TG', 228, 1, 0, 0, 1, ''),
(34, 6, 'BO', 591, 1, 0, 0, 1, ''),(35, 4, 'MU', 230, 1, 0, 0, 1, ''),(36, 1, 'RO', 40, 1, 0, 0, 1, 'NNNNNN'),(37, 1, 'SK', 421, 1, 0, 0, 1, 'NNN NN'),(38, 4, 'DZ', 213, 1, 0, 0, 1, 'NNNNN'),
(39, 2, 'AS', 0, 1, 0, 0, 1, ''),(40, 7, 'AD', 376, 1, 0, 0, 1, 'CNNN'),(41, 4, 'AO', 244, 1, 0, 0, 0, ''),(42, 8, 'AI', 0, 1, 0, 0, 1, ''),(43, 2, 'AG', 0, 1, 0, 0, 1, ''),
(44, 6, 'AR', 54, 1, 1, 0, 1, 'LNNNN'),(45, 3, 'AM', 374, 1, 0, 0, 1, 'NNNN'),(46, 8, 'AW', 297, 1, 0, 0, 1, ''),(47, 3, 'AZ', 994, 1, 0, 0, 1, 'CNNNN'),(48, 2, 'BS', 0, 1, 0, 0, 1, ''),
(49, 3, 'BH', 973, 1, 0, 0, 1, ''),(50, 3, 'BD', 880, 1, 0, 0, 1, 'NNNN'),(51, 2, 'BB', 0, 1, 0, 0, 1, 'CNNNNN'),(52, 7, 'BY', 0, 1, 0, 0, 1, 'NNNNNN'),(53, 8, 'BZ', 501, 1, 0, 0, 0, ''),
(54, 4, 'BJ', 229, 1, 0, 0, 0, ''),(55, 2, 'BM', 0, 1, 0, 0, 1, ''),(56, 3, 'BT', 975, 1, 0, 0, 1, ''),(57, 4, 'BW', 267, 1, 0, 0, 1, ''),(58, 6, 'BR', 55, 1, 0, 0, 1, 'NNNNN-NNN'),
(59, 3, 'BN', 673, 1, 0, 0, 1, 'LLNNNN'),(60, 4, 'BF', 226, 1, 0, 0, 1, ''),(61, 3, 'MM', 95, 1, 0, 0, 1, ''),(62, 4, 'BI', 257, 1, 0, 0, 1, ''),(63, 3, 'KH', 855, 1, 0, 0, 1, 'NNNNN'),
(64, 4, 'CM', 237, 1, 0, 0, 1, ''),(65, 4, 'CV', 238, 1, 0, 0, 1, 'NNNN'),(66, 4, 'CF', 236, 1, 0, 0, 1, ''),(67, 4, 'TD', 235, 1, 0, 0, 1, ''),(68, 6, 'CL', 56, 1, 0, 0, 1, 'NNN-NNNN'),
(69, 6, 'CO', 57, 1, 0, 0, 1, 'NNNNNN'),(70, 4, 'KM', 269, 1, 0, 0, 1, ''),(71, 4, 'CD', 242, 1, 0, 0, 1, ''),(72, 4, 'CG', 243, 1, 0, 0, 1, ''),(73, 8, 'CR', 506, 1, 0, 0, 1, 'NNNNN'),
(74, 7, 'HR', 385, 1, 0, 0, 1, 'NNNNN'),(75, 8, 'CU', 53, 1, 0, 0, 1, ''),(76, 1, 'CY', 357, 1, 0, 0, 1, 'NNNN'),(77, 4, 'DJ', 253, 1, 0, 0, 1, ''),(78, 8, 'DM', 0, 1, 0, 0, 1, ''),
(79, 8, 'DO', 0, 1, 0, 0, 1, ''),(80, 3, 'TL', 670, 1, 0, 0, 1, ''),(81, 6, 'EC', 593, 1, 0, 0, 1, 'CNNNNNN'),(82, 4, 'EG', 20, 1, 0, 0, 0, ''),(83, 8, 'SV', 503, 1, 0, 0, 1, ''),
(84, 4, 'GQ', 240, 1, 0, 0, 1, ''),(85, 4, 'ER', 291, 1, 0, 0, 1, ''),(86, 1, 'EE', 372, 1, 0, 0, 1, 'NNNNN'),(87, 4, 'ET', 251, 1, 0, 0, 1, ''),(88, 8, 'FK', 0, 1, 0, 0, 1, 'LLLL NLL'),
(89, 7, 'FO', 298, 1, 0, 0, 1, ''),(90, 5, 'FJ', 679, 1, 0, 0, 1, ''),(91, 4, 'GA', 241, 1, 0, 0, 1, ''),(92, 4, 'GM', 220, 1, 0, 0, 1, ''),(93, 3, 'GE', 995, 1, 0, 0, 1, 'NNNN'),
(94, 4, 'GH', 233, 1, 0, 0, 1, ''),(95, 8, 'GD', 0, 1, 0, 0, 1, ''),(96, 7, 'GL', 299, 1, 0, 0, 1, ''),(97, 7, 'GI', 350, 1, 0, 0, 1, ''),(98, 8, 'GP', 590, 1, 0, 0, 1, ''),
(99, 8, 'GU', 0, 1, 0, 0, 1, ''),(100, 8, 'GT', 502, 1, 0, 0, 1, ''),(101, 7, 'GG', 0, 1, 0, 0, 1, 'LLN NLL'),(102, 4, 'GN', 224, 1, 0, 0, 1, ''),(103, 4, 'GW', 245, 1, 0, 0, 1, ''),
(104, 6, 'GY', 592, 1, 0, 0, 1, ''),(105, 8, 'HT', 509, 1, 0, 0, 1, ''),(106, 5, 'HM', 0, 1, 0, 0, 1, ''),(107, 7, 'VA', 379, 1, 0, 0, 1, 'NNNNN'),(108, 8, 'HN', 504, 1, 0, 0, 1, ''),
(109, 7, 'IS', 354, 1, 0, 0, 1, 'NNN'),(110, 3, 'IN', 91, 1, 0, 0, 1, 'NNN NNN'),(111, 3, 'ID', 62, 1, 0, 0, 1, 'NNNNN'),(112, 3, 'IR', 98, 1, 0, 0, 1, 'NNNNN-NNNNN'),
(113, 3, 'IQ', 964, 1, 0, 0, 1, 'NNNNN'),(114, 7, 'IM', 0, 1, 0, 0, 1, 'CN NLL'),(115, 8, 'JM', 0, 1, 0, 0, 1, ''),(116, 7, 'JE', 0, 1, 0, 0, 1, 'CN NLL'),(117, 3, 'JO', 962, 1, 0, 0, 1, ''),
(118, 3, 'KZ', 7, 1, 0, 0, 1, 'NNNNNN'),(119, 4, 'KE', 254, 1, 0, 0, 1, ''),(120, 7, 'KI', 686, 1, 0, 0, 1, ''),(121, 3, 'KP', 850, 1, 0, 0, 1, ''),(122, 3, 'KW', 965, 1, 0, 0, 1, ''),
(123, 3, 'KG', 996, 1, 0, 0, 1, ''),(124, 3, 'LA', 856, 1, 0, 0, 1, ''),(125, 1, 'LV', 371, 1, 0, 0, 1, 'C-NNNN'),(126, 3, 'LB', 961, 1, 0, 0, 1, ''),(127, 4, 'LS', 266, 1, 0, 0, 1, ''),
(128, 4, 'LR', 231, 1, 0, 0, 1, ''),(129, 4, 'LY', 218, 1, 0, 0, 1, ''),(130, 1, 'LI', 423, 1, 0, 0, 1, 'NNNN'),(131, 1, 'LT', 370, 1, 0, 0, 1, 'NNNNN'),(132, 3, 'MO', 853, 1, 0, 0, 0, ''),
(133, 7, 'MK', 389, 1, 0, 0, 1, ''),(134, 4, 'MG', 261, 1, 0, 0, 1, ''),(135, 4, 'MW', 265, 1, 0, 0, 1, ''),(136, 3, 'MY', 60, 1, 0, 0, 1, 'NNNNN'),(137, 3, 'MV', 960, 1, 0, 0, 1, ''),
(138, 4, 'ML', 223, 1, 0, 0, 1, ''),(139, 1, 'MT', 356, 1, 0, 0, 1, 'LLL NNNN'),(140, 5, 'MH', 692, 1, 0, 0, 1, ''),(141, 8, 'MQ', 596, 1, 0, 0, 1, ''),(142, 4, 'MR', 222, 1, 0, 0, 1, ''),
(143, 1, 'HU', 36, 1, 0, 0, 1, 'NNNN'),(144, 4, 'YT', 262, 1, 0, 0, 1, ''),(145, 2, 'MX', 52, 1, 0, 0, 1, 'NNNNN'),(146, 5, 'FM', 691, 1, 0, 0, 1, ''),(147, 7, 'MD', 373, 1, 0, 0, 1, 'C-NNNN'),
(148, 7, 'MC', 377, 1, 0, 0, 1, '980NN'),(149, 3, 'MN', 976, 1, 0, 0, 1, ''),(150, 7, 'ME', 382, 1, 0, 0, 1, 'NNNNN'),(151, 8, 'MS', 0, 1, 0, 0, 1, ''),(152, 4, 'MA', 212, 1, 0, 0, 1, 'NNNNN'),
(153, 4, 'MZ', 258, 1, 0, 0, 1, ''),(154, 4, 'NA', 264, 1, 0, 0, 1, ''),(155, 5, 'NR', 674, 1, 0, 0, 1, ''),(156, 3, 'NP', 977, 1, 0, 0, 1, ''),(157, 8, 'AN', 599, 1, 0, 0, 1, ''),
(158, 5, 'NC', 687, 1, 0, 0, 1, ''),(159, 8, 'NI', 505, 1, 0, 0, 1, 'NNNNNN'),(160, 4, 'NE', 227, 1, 0, 0, 1, ''),(161, 5, 'NU', 683, 1, 0, 0, 1, ''),(162, 5, 'NF', 0, 1, 0, 0, 1, ''),
(163, 5, 'MP', 0, 1, 0, 0, 1, ''),(164, 3, 'OM', 968, 1, 0, 0, 1, ''),(165, 3, 'PK', 92, 1, 0, 0, 1, ''),(166, 5, 'PW', 680, 1, 0, 0, 1, ''),(167, 3, 'PS', 0, 1, 0, 0, 1, ''),
(168, 8, 'PA', 507, 1, 0, 0, 1, 'NNNNNN'),(169, 5, 'PG', 675, 1, 0, 0, 1, ''),(170, 6, 'PY', 595, 1, 0, 0, 1, ''),(171, 6, 'PE', 51, 1, 0, 0, 1, ''),(172, 3, 'PH', 63, 1, 0, 0, 1, 'NNNN'),
(173, 5, 'PN', 0, 1, 0, 0, 1, 'LLLL NLL'),(174, 8, 'PR', 0, 1, 0, 0, 1, 'NNNNN'),(175, 3, 'QA', 974, 1, 0, 0, 1, ''),(176, 4, 'RE', 262, 1, 0, 0, 1, ''),(177, 7, 'RU', 7, 1, 0, 0, 1, 'NNNNNN'),
(178, 4, 'RW', 250, 1, 0, 0, 1, ''),(179, 8, 'BL', 0, 1, 0, 0, 1, ''),(180, 8, 'KN', 0, 1, 0, 0, 1, ''),(181, 8, 'LC', 0, 1, 0, 0, 1, ''),(182, 8, 'MF', 0, 1, 0, 0, 1, ''),
(183, 8, 'PM', 508, 1, 0, 0, 1, ''),(184, 8, 'VC', 0, 1, 0, 0, 1, ''),(185, 5, 'WS', 685, 1, 0, 0, 1, ''),(186, 7, 'SM', 378, 1, 0, 0, 1, 'NNNNN'),(187, 4, 'ST', 239, 1, 0, 0, 1, ''),
(188, 3, 'SA', 966, 1, 0, 0, 1, ''),(189, 4, 'SN', 221, 1, 0, 0, 1, ''),(190, 7, 'RS', 381, 1, 0, 0, 1, 'NNNNN'),(191, 4, 'SC', 248, 1, 0, 0, 1, ''),(192, 4, 'SL', 232, 1, 0, 0, 1, ''),
(193, 1, 'SI', 386, 1, 0, 0, 1, 'C-NNNN'),(194, 5, 'SB', 677, 1, 0, 0, 1, ''),(195, 4, 'SO', 252, 1, 0, 0, 1, ''),(196, 8, 'GS', 0, 1, 0, 0, 1, 'LLLL NLL'),(197, 3, 'LK', 94, 1, 0, 0, 1, 'NNNNN'),
(198, 4, 'SD', 249, 1, 0, 0, 1, ''),(199, 8, 'SR', 597, 1, 0, 0, 1, ''),(200, 7, 'SJ', 0, 1, 0, 0, 1, ''),(201, 4, 'SZ', 268, 1, 0, 0, 1, ''),(202, 3, 'SY', 963, 1, 0, 0, 1, ''),
(203, 3, 'TW', 886, 1, 0, 0, 1, 'NNNNN'),(204, 3, 'TJ', 992, 1, 0, 0, 1, ''),(205, 4, 'TZ', 255, 1, 0, 0, 1, ''),(206, 3, 'TH', 66, 1, 0, 0, 1, 'NNNNN'),(207, 5, 'TK', 690, 1, 0, 0, 1, ''),
(208, 5, 'TO', 676, 1, 0, 0, 1, ''),(209, 6, 'TT', 0, 1, 0, 0, 1, ''),(210, 4, 'TN', 216, 1, 0, 0, 1, ''),(211, 7, 'TR', 90, 1, 0, 0, 1, 'NNNNN'),(212, 3, 'TM', 993, 1, 0, 0, 1, ''),
(213, 8, 'TC', 0, 1, 0, 0, 1, 'LLLL NLL'),(214, 5, 'TV', 688, 1, 0, 0, 1, ''),(215, 4, 'UG', 256, 1, 0, 0, 1, ''),(216, 1, 'UA', 380, 1, 0, 0, 1, 'NNNNN'),(217, 3, 'AE', 971, 1, 0, 0, 1, ''),
(218, 6, 'UY', 598, 1, 0, 0, 1, ''),(219, 3, 'UZ', 998, 1, 0, 0, 1, ''),(220, 5, 'VU', 678, 1, 0, 0, 1, ''),(221, 6, 'VE', 58, 1, 0, 0, 1, ''),(222, 3, 'VN', 84, 1, 0, 0, 1, 'NNNNNN'),
(223, 2, 'VG', 0, 1, 0, 0, 1, 'CNNNN'),(224, 2, 'VI', 0, 1, 0, 0, 1, ''),(225, 5, 'WF', 681, 1, 0, 0, 1, ''),(226, 4, 'EH', 0, 1, 0, 0, 1, ''),(227, 3, 'YE', 967, 1, 0, 0, 1, ''),
(228, 4, 'ZM', 260, 1, 0, 0, 1, ''),(229, 4, 'ZW', 263, 1, 0, 0, 1, ''),(230, 7, 'AL', 355, 1, 0, 0, 1, 'NNNN'),(231, 3, 'AF', 93, 1, 0, 0, 0, ''),(232, 5, 'AQ', 0, 1, 0, 0, 1, ''),
(233, 1, 'BA', 387, 1, 0, 0, 1, ''),(234, 5, 'BV', 0, 1, 0, 0, 1, ''),(235, 5, 'IO', 0, 1, 0, 0, 1, 'LLLL NLL'),(236, 1, 'BG', 359, 1, 0, 0, 1, 'NNNN'),(237, 8, 'KY', 0, 1, 0, 0, 1, ''),
(238, 3, 'CX', 0, 1, 0, 0, 1, ''),(239, 3, 'CC', 0, 1, 0, 0, 1, ''),(240, 5, 'CK', 682, 1, 0, 0, 1, ''),(241, 6, 'GF', 594, 1, 0, 0, 1, ''),(242, 5, 'PF', 689, 1, 0, 0, 1, ''),
(243, 5, 'TF', 0, 1, 0, 0, 1, ''),(244, 7, 'AX', 0, 1, 0, 0, 1, 'NNNNN');

INSERT INTO `PREFIX_country_lang` (`id_country`, `id_lang`, `name`) VALUES
(1, 1, 'Germany'),(1, 2, 'Allemagne'),(1, 3, 'Alemania'),(2, 1, 'Austria'),(2, 2, 'Autriche'),(2, 3, 'Austria'),
(3, 1, 'Belgium'),(3, 2, 'Belgique'),(3, 3, 'Bélgica'),(4, 1, 'Canada'),(4, 2, 'Canada'),(4, 3, 'Canadá'),(5, 1, 'China'),
(5, 2, 'Chine'),(5, 3, 'Porcelana'),(6, 1, 'Spain'),(6, 2, 'Espagne'),(6, 3, 'España'),(7, 1, 'Finland'),(7, 2, 'Finlande'),
(7, 3, 'Finlandia'),(8, 1, 'France'),(8, 2, 'France'),(8, 3, 'Francia'),(9, 1, 'Greece'),(9, 2, 'Grèce'),(9, 3, 'Grecia'),
(10, 1, 'Italy'),(10, 2, 'Italie'),(10, 3, 'Italia'),(11, 1, 'Japan'),(11, 2, 'Japon'),(11, 3, 'Japón'),
(12, 1, 'Luxemburg'),(12, 2, 'Luxembourg'),(12, 3, 'Luxemburgo'),(13, 1, 'Netherlands'),(13, 2, 'Pays-bas'),(13, 3, 'Países Bajos'),
(14, 1, 'Poland'),(14, 2, 'Pologne'),(14, 3, 'Polonia'),(15, 1, 'Portugal'),(15, 2, 'Portugal'),(15, 3, 'Portugal'),
(16, 1, 'Czech Republic'),(16, 2, 'République Tchèque'),(16, 3, 'República Checa'),(17, 1, 'United Kingdom'),(17, 2, 'Royaume-Uni'),(17, 3, 'Reino Unido'),
(18, 1, 'Sweden'),(18, 2, 'Suède'),(18, 3, 'Suecia'),(19, 1, 'Switzerland'),(19, 2, 'Suisse'),(19, 3, 'Suiza'),(20, 1, 'Denmark'),
(20, 2, 'Danemark'),(20, 3, 'Dinamarca'),(21, 1, 'USA'),(21, 2, 'États-Unis'),(21, 3, 'EE.UU.'),(22, 1, 'HongKong'),(22, 2, 'Hong-Kong'),
(22, 3, 'Hong Kong'),(23, 1, 'Norway'),(23, 2, 'Norvège'),(23, 3, 'Noruega'),(24, 1, 'Australia'),(24, 2, 'Australie'),(24, 3, 'Australia'),
(25, 1, 'Singapore'),(25, 2, 'Singapour'),(25, 3, 'Singapur'),(26, 1, 'Ireland'),(26, 2, 'Eire'),(26, 3, 'Irlanda'),(27, 1, 'New Zealand'),
(27, 2, 'Nouvelle-Zélande'),(27, 3, 'Nueva Zelanda'),(28, 1, 'South Korea'),(28, 2, 'Corée du Sud'),(28, 3, 'Corea del Sur'),(29, 1, 'Israel'),
(29, 2, 'Israël'),(29, 3, 'Israel'),(30, 1, 'South Africa'),(30, 2, 'Afrique du Sud'),(30, 3, 'Sudáfrica'),(31, 1, 'Nigeria'),(31, 2, 'Nigeria'),
(31, 3, 'Nigeria'),(32, 1, 'Ivory Coast'),(32, 2, 'Côte d''Ivoire'),(32, 3, 'Costa de Marfil'),(33, 1, 'Togo'),(33, 2, 'Togo'),(33, 3, 'Togo'),
(34, 1, 'Bolivia'),(34, 2, 'Bolivie'),(34, 3, 'Bolivia'),(35, 1, 'Mauritius'),(35, 2, 'Ile Maurice'),(35, 3, 'Mauricio'),(36, 1, 'Romania'),
(36, 2, 'Roumanie'),(36, 3, 'Rumania'),(37, 1, 'Slovakia'),(37, 2, 'Slovaquie'),(37, 3, 'Eslovaquia'),(38, 1, 'Algeria'),(38, 2, 'Algérie'),
(38, 3, 'Argelia'),(39, 1, 'American Samoa'),(39, 2, 'Samoa Américaines'),(39, 3, 'Samoa Americana'),(40, 1, 'Andorra'),(40, 2, 'Andorre'),(40, 3, 'Andorra'),
(41, 1, 'Angola'),(41, 2, 'Angola'),(41, 3, 'Angola'),(42, 1, 'Anguilla'),(42, 2, 'Anguilla'),(42, 3, 'Anguila'),(43, 1, 'Antigua and Barbuda'),
(43, 2, 'Antigua et Barbuda'),(43, 3, 'Antigua y Barbuda'),(44, 1, 'Argentina'),(44, 2, 'Argentine'),(44, 3, 'Argentina'),(45, 1, 'Armenia'),
(45, 2, 'Arménie'),(45, 3, 'Armenia'),(46, 1, 'Aruba'),(46, 2, 'Aruba'),(46, 3, 'Aruba'),(47, 1, 'Azerbaijan'),(47, 2, 'Azerbaïdjan'),(47, 3, 'Azerbaiyán'),
(48, 1, 'Bahamas'),(48, 2, 'Bahamas'),(48, 3, 'Bahamas'),(49, 1, 'Bahrain'),(49, 2, 'Bahreïn'),(49, 3, 'Bahrein'),(50, 1, 'Bangladesh'),
(50, 2, 'Bangladesh'),(50, 3, 'Bangladesh'),(51, 1, 'Barbados'),(51, 2, 'Barbade'),(51, 3, 'Barbados'),(52, 1, 'Belarus'),(52, 2, 'Bélarus'),
(52, 3, 'Belarús'),(53, 1, 'Belize'),(53, 2, 'Belize'),(53, 3, 'Belice'),(54, 1, 'Benin'),(54, 2, 'Bénin'),(54, 3, 'Benin'),(55, 1, 'Bermuda'),
(55, 2, 'Bermudes'),(55, 3, 'Bermudas'),(56, 1, 'Bhutan'),(56, 2, 'Bhoutan'),(56, 3, 'Bhután'),(57, 1, 'Botswana'),(57, 2, 'Botswana'),(57, 3, 'Botswana'),
(58, 1, 'Brazil'),(58, 2, 'Brésil'),(58, 3, 'Brasil'),(59, 1, 'Brunei'),(59, 2, 'Brunéi Darussalam'),(59, 3, 'Brunei'),(60, 1, 'Burkina Faso'),
(60, 2, 'Burkina Faso'),(60, 3, 'Burkina Faso'),(61, 1, 'Burma (Myanmar)'),(61, 2, 'Burma (Myanmar)'),(61, 3, 'Birmania (Myanmar)'),(62, 1, 'Burundi'),(62, 2, 'Burundi'),
(62, 3, 'Burundi'),(63, 1, 'Cambodia'),(63, 2, 'Cambodge'),(63, 3, 'Camboya'),(64, 1, 'Cameroon'),(64, 2, 'Cameroun'),(64, 3, 'Camerún'),(65, 1, 'Cape Verde'),(65, 2, 'Cap-Vert'),
(65, 3, 'Cabo Verde'),(66, 1, 'Central African Republic'),(66, 2, 'Centrafricaine, République'),(66, 3, 'República Centroafricana'),(67, 1, 'Chad'),(67, 2, 'Tchad'),(67, 3, 'Chad'),
(68, 1, 'Chile'),(68, 2, 'Chili'),(68, 3, 'Chile'),(69, 1, 'Colombia'),(69, 2, 'Colombie'),(69, 3, 'Colombia'),(70, 1, 'Comoros'),(70, 2, 'Comores'),
(70, 3, 'Comoras'),(71, 1, 'Congo, Dem. Republic'),(71, 2, 'Congo, Rép. Dém.'),(71, 3, 'Congo, Rep. Dem.'),(72, 1, 'Congo, Republic'),(72, 2, 'Congo, Rép.'),(72, 3, 'Congo, República'),
(73, 1, 'Costa Rica'),(73, 2, 'Costa Rica'),(73, 3, 'Costa Rica'),(74, 1, 'Croatia'),(74, 2, 'Croatie'),(74, 3, 'Croacia'),(75, 1, 'Cuba'),
(75, 2, 'Cuba'),(75, 3, 'Cuba'),(76, 1, 'Cyprus'),(76, 2, 'Chypre'),(76, 3, 'Chipre'),(77, 1, 'Djibouti'),(77, 2, 'Djibouti'),(77, 3, 'Djibouti'),(78, 1, 'Dominica'),
(78, 2, 'Dominica'),(78, 3, 'Dominica'),(79, 1, 'Dominican Republic'),(79, 2, 'République Dominicaine'),(79, 3, 'República Dominicana'),(80, 1, 'East Timor'),(80, 2, 'Timor oriental'),
(80, 3, 'Timor Oriental'),(81, 1, 'Ecuador'),(81, 2, 'Équateur'),(81, 3, 'Ecuador'),(82, 1, 'Egypt'),(82, 2, 'Égypte'),(82, 3, 'Egipto'),(83, 1, 'El Salvador'),
(83, 2, 'El Salvador'),(83, 3, 'El Salvador'),(84, 1, 'Equatorial Guinea'),(84, 2, 'Guinée Équatoriale'),(84, 3, 'Guinea Ecuatorial'),(85, 1, 'Eritrea'),
(85, 2, 'Érythrée'),(85, 3, 'Eritrea'),(86, 1, 'Estonia'),(86, 2, 'Estonie'),(86, 3, 'Estonia'),(87, 1, 'Ethiopia'),(87, 2, 'Éthiopie'),(87, 3, 'Etiopía'),
(88, 1, 'Falkland Islands'),(88, 2, 'Falkland, Îles'),(88, 3, 'Islas Malvinas'),(89, 1, 'Faroe Islands'),(89, 2, 'Féroé, Îles'),(89, 3, 'Islas Feroe'),(90, 1, 'Fiji'),(90, 2, 'Fidji'),
(90, 3, 'Fiji'),(91, 1, 'Gabon'),(91, 2, 'Gabon'),(91, 3, 'Gabón'),(92, 1, 'Gambia'),(92, 2, 'Gambie'),(92, 3, 'Gambia'),(93, 1, 'Georgia'),
(93, 2, 'Géorgie'),(93, 3, 'Georgia'),(94, 1, 'Ghana'),(94, 2, 'Ghana'),(94, 3, 'Ghana'),(95, 1, 'Grenada'),(95, 2, 'Grenade'),(95, 3, 'Granada'),
(96, 1, 'Greenland'),(96, 2, 'Groenland'),(96, 3, 'Groenlandia'),(97, 1, 'Gibraltar'),(97, 2, 'Gibraltar'),(97, 3, 'Gibraltar'),(98, 1, 'Guadeloupe'),(98, 2, 'Guadeloupe'),
(98, 3, 'Guadalupe'),(99, 1, 'Guam'),(99, 2, 'Guam'),(99, 3, 'Guam'),(100, 1, 'Guatemala'),(100, 2, 'Guatemala'),(100, 3, 'Guatemala'),(101, 1, 'Guernsey'),
(101, 2, 'Guernesey'),(101, 3, 'Guernsey'),(102, 1, 'Guinea'),(102, 2, 'Guinée'),(102, 3, 'Guinea'),(103, 1, 'Guinea-Bissau'),(103, 2, 'Guinée-Bissau'),
(103, 3, 'Guinea-Bissau'),(104, 1, 'Guyana'),(104, 2, 'Guyana'),(104, 3, 'Guyana'),(105, 1, 'Haiti'),(105, 2, 'Haîti'),(105, 3, 'Haití'),(106, 1, 'Heard Island and McDonald Islands'),(106, 2, 'Heard, Île et Mcdonald, Îles'),
(106, 3, 'Islas Heard y McDonald Islas'),(107, 1, 'Vatican City State'),(107, 2, 'Saint-Siege (État de la Cité du Vatican)'),(107, 3, 'Ciudad del Vaticano'),(108, 1, 'Honduras'),(108, 2, 'Honduras'),(108, 3, 'Honduras'),(109, 1, 'Iceland'),
(109, 2, 'Islande'),(109, 3, 'Islandia'),(110, 1, 'India'),(110, 2, 'Inde'),(110, 3, 'India'),(111, 1, 'Indonesia'),(111, 2, 'Indonésie'),
(111, 3, 'Indonesia'),(112, 1, 'Iran'),(112, 2, 'Iran'),(112, 3, 'Irán'),(113, 1, 'Iraq'),(113, 2, 'Iraq'),(113, 3, 'Iraq'),(114, 1, 'Man Island'),
(114, 2, 'Man, Île de'),(114, 3, 'Man, Isla'),(115, 1, 'Jamaica'),(115, 2, 'Jamaique'),(115, 3, 'Jamaica'),(116, 1, 'Jersey'),(116, 2, 'Jersey'),
(116, 3, 'Jersey'),(117, 1, 'Jordan'),(117, 2, 'Jordanie'),(117, 3, 'Jordania'),(118, 1, 'Kazakhstan'),(118, 2, 'Kazakhstan'),(118, 3, 'Kazajstán'),(119, 1, 'Kenya'),
(119, 2, 'Kenya'),(119, 3, 'Kenya'),(120, 1, 'Kiribati'),(120, 2, 'Kiribati'),(120, 3, 'Kiribati'),(121, 1, 'Korea, Dem. Republic of'),(121, 2, 'Corée, Rép. Populaire Dém. de'),(121, 3, 'KOREA, DEM. República de'),
(122, 1, 'Kuwait'),(122, 2, 'Koweït'),(122, 3, 'Kuwait'),(123, 1, 'Kyrgyzstan'),(123, 2, 'Kirghizistan'),(123, 3, 'Kirguistán'),(124, 1, 'Laos'),(124, 2, 'Laos'),
(124, 3, 'Laos'),(125, 1, 'Latvia'),(125, 2, 'Lettonie'),(125, 3, 'Letonia'),(126, 1, 'Lebanon'),(126, 2, 'Liban'),(126, 3, 'Líbano'),(127, 1, 'Lesotho'),
(127, 2, 'Lesotho'),(127, 3, 'Lesotho'),(128, 1, 'Liberia'),(128, 2, 'Libéria'),(128, 3, 'Liberia'),(129, 1, 'Libya'),(129, 2, 'Libyenne, Jamahiriya Arabe'),(129, 3, 'Libia'),
(130, 1, 'Liechtenstein'),(130, 2, 'Liechtenstein'),(130, 3, 'Liechtenstein'),(131, 1, 'Lithuania'),(131, 2, 'Lituanie'),(131, 3, 'Lituania'),(132, 1, 'Macau'),
(132, 2, 'Macao'),(132, 3, 'Macao'),(133, 1, 'Macedonia'),(133, 2, 'Macédoine'),(133, 3, 'Macedonia'),(134, 1, 'Madagascar'),(134, 2, 'Madagascar'),
(134, 3, 'Madagascar'),(135, 1, 'Malawi'),(135, 2, 'Malawi'),(135, 3, 'Malawi'),(136, 1, 'Malaysia'),(136, 2, 'Malaisie'),(136, 3, 'Malasia'),
(137, 1, 'Maldives'),(137, 2, 'Maldives'),(137, 3, 'Maldivas'),(138, 1, 'Mali'),(138, 2, 'Mali'),(138, 3, 'Malí'),(139, 1, 'Malta'),(139, 2, 'Malte'),
(139, 3, 'Malta'),(140, 1, 'Marshall Islands'),(140, 2, 'Marshall, Îles'),(140, 3, 'Marshall, Islas'),(141, 1, 'Martinique'),(141, 2, 'Martinique'),
(141, 3, 'Martinica'),(142, 1, 'Mauritania'),(142, 2, 'Mauritanie'),(142, 3, 'Mauritania'),(143, 1, 'Hungary'),(143, 2, 'Hongrie'),(143, 3, 'Hungría'),
(144, 1, 'Mayotte'),(144, 2, 'Mayotte'),(144, 3, 'Mayotte'),(145, 1, 'Mexico'),(145, 2, 'Mexique'),(145, 3, 'México'),(146, 1, 'Micronesia'),(146, 2, 'Micronésie'),
(146, 3, 'Micronesia'),(147, 1, 'Moldova'),(147, 2, 'Moldova'),(147, 3, 'Moldavia'),(148, 1, 'Monaco'),(148, 2, 'Monaco'),(148, 3, 'Mónaco'),
(149, 1, 'Mongolia'),(149, 2, 'Mongolie'),(149, 3, 'Mongolia'),(150, 1, 'Montenegro'),(150, 2, 'Monténégro'),(150, 3, 'Montenegro'),(151, 1, 'Montserrat'),
(151, 2, 'Montserrat'),(151, 3, 'Montserrat'),(152, 1, 'Morocco'),(152, 2, 'Maroc'),(152, 3, 'Marruecos'),(153, 1, 'Mozambique'),(153, 2, 'Mozambique'),(153, 3, 'Mozambique'),
(154, 1, 'Namibia'),(154, 2, 'Namibie'),(154, 3, 'Namibia'),(155, 1, 'Nauru'),(155, 2, 'Nauru'),(155, 3, 'Nauru'),(156, 1, 'Nepal'),(156, 2, 'Népal'),
(156, 3, 'Nepal'),(157, 1, 'Netherlands Antilles'),(157, 2, 'Antilles Néerlandaises'),(157, 3, 'Antillas Neerlandesas'),(158, 1, 'New Caledonia'),(158, 2, 'Nouvelle-Calédonie'),(158, 3, 'Nueva Caledonia'),
(159, 1, 'Nicaragua'),(159, 2, 'Nicaragua'),(159, 3, 'Nicaragua'),(160, 1, 'Niger'),(160, 2, 'Niger'),(160, 3, 'Níger'),(161, 1, 'Niue'),
(161, 2, 'Niué'),(161, 3, 'Niue'),(162, 1, 'Norfolk Island'),(162, 2, 'Norfolk, Île'),(162, 3, 'Norfolk Island'),(163, 1, 'Northern Mariana Islands'),(163, 2, 'Mariannes du Nord, Îles'),
(163, 3, 'Islas Marianas del Norte'),(164, 1, 'Oman'),(164, 2, 'Oman'),(164, 3, 'Omán'),(165, 1, 'Pakistan'),(165, 2, 'Pakistan'),(165, 3, 'Pakistán'),
(166, 1, 'Palau'),(166, 2, 'Palaos'),(166, 3, 'Palau'),(167, 1, 'Palestinian Territories'),(167, 2, 'Palestinien Occupé, Territoire'),(167, 3, 'Territorios Palestinos'),(168, 1, 'Panama'),
(168, 2, 'Panama'),(168, 3, 'Panamá'),(169, 1, 'Papua New Guinea'),(169, 2, 'Papouasie-Nouvelle-Guinée'),(169, 3, 'Papua Nueva Guinea'),(170, 1, 'Paraguay'),(170, 2, 'Paraguay'),
(170, 3, 'Paraguay'),(171, 1, 'Peru'),(171, 2, 'Pérou'),(171, 3, 'Perú'),(172, 1, 'Philippines'),(172, 2, 'Philippines'),(172, 3, 'Filipinas'),(173, 1, 'Pitcairn'),
(173, 2, 'Pitcairn'),(173, 3, 'Pitcairn'),(174, 1, 'Puerto Rico'),(174, 2, 'Porto Rico'),(174, 3, 'Puerto Rico'),(175, 1, 'Qatar'),(175, 2, 'Qatar'),(175, 3, 'Qatar'),
(176, 1, 'Reunion Island'),(176, 2, 'Réunion, Île de la'),(176, 3, 'Reunión, Isla de la'),(177, 1, 'Russian Federation'),(177, 2, 'Russie, Fédération de'),(177, 3, 'Rusia, Federación de'),(178, 1, 'Rwanda'),
(178, 2, 'Rwanda'),(178, 3, 'Rwanda'),(179, 1, 'Saint Barthelemy'),(179, 2, 'Saint-Barthélemy'),(179, 3, 'San Bartolomé'),(180, 1, 'Saint Kitts and Nevis'),(180, 2, 'Saint-Kitts-et-Nevis'),
(180, 3, 'Saint Kitts y Nevis'),(181, 1, 'Saint Lucia'),(181, 2, 'Sainte-Lucie'),(181, 3, 'Santa Lucía'),(182, 1, 'Saint Martin'),(182, 2, 'Saint-Martin'),(182, 3, 'Saint Martin'),
(183, 1, 'Saint Pierre and Miquelon'),(183, 2, 'Saint-Pierre-et-Miquelon'),(183, 3, 'San Pedro y Miquelón'),(184, 1, 'Saint Vincent and the Grenadines'),(184, 2, 'Saint-Vincent-et-Les Grenadines'),(184, 3, 'San Vicente y las Granadinas'),(185, 1, 'Samoa'),
(185, 2, 'Samoa'),(185, 3, 'Samoa'),(186, 1, 'San Marino'),(186, 2, 'Saint-Marin'),(186, 3, 'San Marino'),(187, 1, 'São Tomé and Príncipe'),(187, 2, 'Sao Tomé-et-Principe'),(187, 3, 'Santo Tomé y Príncipe'),
(188, 1, 'Saudi Arabia'),(188, 2, 'Arabie Saoudite'),(188, 3, 'Arabia Saudita'),(189, 1, 'Senegal'),(189, 2, 'Sénégal'),(189, 3, 'Senegal'),(190, 1, 'Serbia'),
(190, 2, 'Serbie'),(190, 3, 'Serbia'),(191, 1, 'Seychelles'),(191, 2, 'Seychelles'),(191, 3, 'Seychelles'),(192, 1, 'Sierra Leone'),(192, 2, 'Sierra Leone'),
(192, 3, 'Sierra Leona'),(193, 1, 'Slovenia'),(193, 2, 'Slovénie'),(193, 3, 'Eslovenia'),(194, 1, 'Solomon Islands'),(194, 2, 'Salomon, Îles'),(194, 3, 'Salomón, Islas'),(195, 1, 'Somalia'),
(195, 2, 'Somalie'),(195, 3, 'Somalia'),(196, 1, 'South Georgia and the South Sandwich Islands'),(196, 2, 'Géorgie du Sud et les Îles Sandwich du Sud'),(196, 3, 'Georgia del Sur e Islas Sandwich del Sur'),(197, 1, 'Sri Lanka'),(197, 2, 'Sri Lanka'),
(197, 3, 'Sri Lanka'),(198, 1, 'Sudan'),(198, 2, 'Soudan'),(198, 3, 'Sudán'),(199, 1, 'Suriname'),(199, 2, 'Suriname'),(199, 3, 'Suriname'),(200, 1, 'Svalbard and Jan Mayen'),
(200, 2, 'Svalbard et Île Jan Mayen'),(200, 3, 'Svalbard y Jan Mayen'),(201, 1, 'Swaziland'),(201, 2, 'Swaziland'),(201, 3, 'Swazilandia'),(202, 1, 'Syria'),(202, 2, 'Syrienne'),
(202, 3, 'Siria'),(203, 1, 'Taiwan'),(203, 2, 'Taïwan'),(203, 3, 'Taiwán'),(204, 1, 'Tajikistan'),(204, 2, 'Tadjikistan'),(204, 3, 'Tayikistán'),
(205, 1, 'Tanzania'),(205, 2, 'Tanzanie'),(205, 3, 'Tanzania'),(206, 1, 'Thailand'),(206, 2, 'Thaïlande'),(206, 3, 'Tailandia'),(207, 1, 'Tokelau'),
(207, 2, 'Tokelau'),(207, 3, 'Tokelau'),(208, 1, 'Tonga'),(208, 2, 'Tonga'),(208, 3, 'Tonga'),(209, 1, 'Trinidad and Tobago'),(209, 2, 'Trinité-et-Tobago'),(209, 3, 'Trinidad y Tobago'),
(210, 1, 'Tunisia'),(210, 2, 'Tunisie'),(210, 3, 'Túnez'),(211, 1, 'Turkey'),(211, 2, 'Turquie'),(211, 3, 'Turquía'),(212, 1, 'Turkmenistan'),(212, 2, 'Turkménistan'),
(212, 3, 'Turkmenistán'),(213, 1, 'Turks and Caicos Islands'),(213, 2, 'Turks et Caiques, Îles'),(213, 3, 'Islas Turcas y Caicos'),(214, 1, 'Tuvalu'),(214, 2, 'Tuvalu'),(214, 3, 'Tuvalu'),
(215, 1, 'Uganda'),(215, 2, 'Ouganda'),(215, 3, 'Uganda'),(216, 1, 'Ukraine'),(216, 2, 'Ukraine'),(216, 3, 'Ucrania'),(217, 1, 'United Arab Emirates'),
(217, 2, 'Émirats Arabes Unis'),(217, 3, 'Emiratos Árabes Unidos'),(218, 1, 'Uruguay'),(218, 2, 'Uruguay'),(218, 3, 'Uruguay'),(219, 1, 'Uzbekistan'),(219, 2, 'Ouzbékistan'),
(219, 3, 'Uzbekistán'),(220, 1, 'Vanuatu'),(220, 2, 'Vanuatu'),(220, 3, 'Vanuatu'),(221, 1, 'Venezuela'),(221, 2, 'Venezuela'),(221, 3, 'Venezuela'),
(222, 1, 'Vietnam'),(222, 2, 'Vietnam'),(222, 3, 'Vietnam'),(223, 1, 'Virgin Islands (British)'),(223, 2, 'Îles Vierges Britanniques'),(223, 3, 'Islas Vírgenes (Británicas)'),(224, 1, 'Virgin Islands (U.S.)'),
(224, 2, 'Îles Vierges des États-Unis'),(224, 3, 'Islas Vírgenes (EE.UU.)'),(225, 1, 'Wallis and Futuna'),(225, 2, 'Wallis et Futuna'),(225, 3, 'Wallis y Futuna'),(226, 1, 'Western Sahara'),(226, 2, 'Sahara Occidental'),
(226, 3, 'Sáhara Occidental'),(227, 1, 'Yemen'),(227, 2, 'Yémen'),(227, 3, 'Yemen'),(228, 1, 'Zambia'),(228, 2, 'Zambie'),(228, 3, 'Zambia'),(229, 1, 'Zimbabwe'),
(229, 2, 'Zimbabwe'),(229, 3, 'Zimbabwe'),(230, 1, 'Albania'),(230, 2, 'Albanie'),(230, 3, 'Albania'),(231, 1, 'Afghanistan'),(231, 2, 'Afghanistan'),(231, 3, 'Afganistán'),
(232, 1, 'Antarctica'),(232, 2, 'Antarctique'),(232, 3, 'Antártida'),(233, 1, 'Bosnia and Herzegovina'),(233, 2, 'Bosnie-Herzégovine'),(233, 3, 'Bosnia y Herzegovina'),(234, 1, 'Bouvet Island'),
(234, 2, 'Bouvet, Île'),(234, 3, 'Isla Bouvet'),(235, 1, 'British Indian Ocean Territory'),(235, 2, 'Océan Indien, Territoire Britannique de L'''),(235, 3, 'British Indian Ocean Territory'),(236, 1, 'Bulgaria'),(236, 2, 'Bulgarie'),
(236, 3, 'Bulgaria'),(237, 1, 'Cayman Islands'),(237, 2, 'Caïmans, Îles'),(237, 3, 'Caimán, Islas'),(238, 1, 'Christmas Island'),(238, 2, 'Christmas, Île'),(238, 3, 'Navidad, Isla de'),
(239, 1, 'Cocos (Keeling) Islands'),(239, 2, 'Cocos (Keeling), Îles'),(239, 3, 'Cocos (Keeling), Islas'),(240, 1, 'Cook Islands'),(240, 2, 'Cook, Îles'),(240, 3, 'Cook, Islas'),
(241, 1, 'French Guiana'),(241, 2, 'Guyane Française'),(241, 3, 'Francés Guayana'),(242, 1, 'French Polynesia'),(242, 2, 'Polynésie Française'),(242, 3, 'Polinesia francés'),(243, 1, 'French Southern Territories'),
(243, 2, 'Terres Australes Françaises'),(243, 3, 'Territorios del sur francés'),(244, 1, 'Åland Islands'),(244, 2, 'Åland, Îles'),(244, 3, 'Islas Åland');

INSERT IGNORE INTO `PREFIX_country_lang` (`id_country`, `id_lang`, `name`)
    (SELECT `id_country`, id_lang, (SELECT tl.`name`
        FROM `PREFIX_country_lang` tl
        WHERE tl.`id_lang` = (SELECT c.`value`
            FROM `PREFIX_configuration` c
            WHERE c.`name` = 'PS_LANG_DEFAULT' LIMIT 1) AND tl.`id_country`=`PREFIX_country`.`id_country`)
    FROM `PREFIX_lang` CROSS JOIN `PREFIX_country`);

INSERT INTO `PREFIX_state` (`id_state`, `id_country`, `id_zone`, `name`, `iso_code`, `active`) VALUES
(1, 21, 2, 'Alabama', 'AL', 1),(2, 21, 2, 'Alaska', 'AK', 1),(3, 21, 2, 'Arizona', 'AZ', 1),(4, 21, 2, 'Arkansas', 'AR', 1),
(5, 21, 2, 'California', 'CA', 1),(6, 21, 2, 'Colorado', 'CO', 1),(7, 21, 2, 'Connecticut', 'CT', 1),(8, 21, 2, 'Delaware', 'DE', 1),
(9, 21, 2, 'Florida', 'FL', 1),(10, 21, 2, 'Georgia', 'GA', 1),(11, 21, 2, 'Hawaii', 'HI', 1),(12, 21, 2, 'Idaho', 'ID', 1),
(13, 21, 2, 'Illinois', 'IL', 1),(14, 21, 2, 'Indiana', 'IN', 1),(15, 21, 2, 'Iowa', 'IA', 1),(16, 21, 2, 'Kansas', 'KS', 1),
(17, 21, 2, 'Kentucky', 'KY', 1),(18, 21, 2, 'Louisiana', 'LA', 1),(19, 21, 2, 'Maine', 'ME', 1),(20, 21, 2, 'Maryland', 'MD', 1),
(21, 21, 2, 'Massachusetts', 'MA', 1),(22, 21, 2, 'Michigan', 'MI', 1),(23, 21, 2, 'Minnesota', 'MN', 1),
(24, 21, 2, 'Mississippi', 'MS', 1),(25, 21, 2, 'Missouri', 'MO', 1),(26, 21, 2, 'Montana', 'MT', 1),(27, 21, 2, 'Nebraska', 'NE', 1),
(28, 21, 2, 'Nevada', 'NV', 1),(29, 21, 2, 'New Hampshire', 'NH', 1),(30, 21, 2, 'New Jersey', 'NJ', 1),(31, 21, 2, 'New Mexico', 'NM', 1),
(32, 21, 2, 'New York', 'NY', 1),(33, 21, 2, 'North Carolina', 'NC', 1),(34, 21, 2, 'North Dakota', 'ND', 1),(35, 21, 2, 'Ohio', 'OH', 1),
(36, 21, 2, 'Oklahoma', 'OK', 1),(37, 21, 2, 'Oregon', 'OR', 1),(38, 21, 2, 'Pennsylvania', 'PA', 1),(39, 21, 2, 'Rhode Island', 'RI', 1),
(40, 21, 2, 'South Carolina', 'SC', 1),(41, 21, 2, 'South Dakota', 'SD', 1),(42, 21, 2, 'Tennessee', 'TN', 1),(43, 21, 2, 'Texas', 'TX', 1),
(44, 21, 2, 'Utah', 'UT', 1),(45, 21, 2, 'Vermont', 'VT', 1),(46, 21, 2, 'Virginia', 'VA', 1),(47, 21, 2, 'Washington', 'WA', 1),
(48, 21, 2, 'West Virginia', 'WV', 1),(49, 21, 2, 'Wisconsin', 'WI', 1),(50, 21, 2, 'Wyoming', 'WY', 1),(51, 21, 2, 'Puerto Rico', 'PR', 1),
(52, 21, 2, 'US Virgin Islands', 'VI', 1),(53, 21, 2, 'District of Columbia', 'DC', 1);

INSERT INTO `PREFIX_state` (`id_country`, `id_zone`, `name`, `iso_code`, `tax_behavior`, `active`) VALUES
(145, 2, 'Aguascalientes', 'AGS', 0, 1),
(145, 2, 'Baja California', 'BCN', 0, 1),
(145, 2, 'Baja California Sur', 'BCS', 0, 1),
(145, 2, 'Campeche', 'CAM', 0, 1),
(145, 2, 'Chiapas', 'CHP', 0, 1),
(145, 2, 'Chihuahua', 'CHH', 0, 1),
(145, 2, 'Coahuila', 'COA', 0, 1),
(145, 2, 'Colima', 'COL', 0, 1),
(145, 2, 'Distrito Federal', 'DIF', 0, 1),
(145, 2, 'Durango', 'DUR', 0, 1),
(145, 2, 'Guanajuato', 'GUA', 0, 1),
(145, 2, 'Guerrero', 'GRO', 0, 1),
(145, 2, 'Hidalgo', 'HID', 0, 1),
(145, 2, 'Jalisco', 'JAL', 0, 1),
(145, 2, 'Estado de México', 'MEX', 0, 1),
(145, 2, 'Michoacán', 'MIC', 0, 1),
(145, 2, 'Morelos', 'MOR', 0, 1),
(145, 2, 'Nayarit', 'NAY', 0, 1),
(145, 2, 'Nuevo León', 'NLE', 0, 1),
(145, 2, 'Oaxaca', 'OAX', 0, 1),
(145, 2, 'Puebla', 'PUE', 0, 1),
(145, 2, 'Querétaro', 'QUE', 0, 1),
(145, 2, 'Quintana Roo', 'ROO', 0, 1),
(145, 2, 'San Luis Potosí', 'SLP', 0, 1),
(145, 2, 'Sinaloa', 'SIN', 0, 1),
(145, 2, 'Sonora', 'SON', 0, 1),
(145, 2, 'Tabasco', 'TAB', 0, 1),
(145, 2, 'Tamaulipas', 'TAM', 0, 1),
(145, 2, 'Tlaxcala', 'TLA', 0, 1),
(145, 2, 'Veracruz', 'VER', 0, 1),
(145, 2, 'Yucatán', 'YUC', 0, 1),
(145, 2, 'Zacatecas', 'ZAC', 0, 1);

INSERT INTO `PREFIX_state` (`id_country`, `id_zone`, `name`, `iso_code`, `active`) VALUES
(4, 2, 'Ontario', 'ON', 1),
(4, 2, 'Quebec', 'QC', 1),
(4, 2, 'British Columbia', 'BC', 1),
(4, 2, 'Alberta', 'AB', 1),
(4, 2, 'Manitoba', 'MB', 1),
(4, 2, 'Saskatchewan', 'SK', 1),
(4, 2, 'Nova Scotia', 'NS', 1),
(4, 2, 'New Brunswick', 'NB', 1),
(4, 2, 'Newfoundland and Labrador', 'NL', 1),
(4, 2, 'Prince Edward Island', 'PE', 1),
(4, 2, 'Northwest Territories', 'NT', 1),
(4, 2, 'Yukon', 'YT', 1),
(4, 2, 'Nunavut', 'NU', 1);

INSERT INTO `PREFIX_state` (`id_country`, `id_zone`, `name`, `iso_code`, `active`) VALUES
(44, 6, 'Buenos Aires', 'B', 1),
(44, 6, 'Catamarca', 'K', 1),
(44, 6, 'Chaco', 'H', 1),
(44, 6, 'Chubut', 'U', 1),
(44, 6, 'Ciudad de Buenos Aires', 'C', 1),
(44, 6, 'Córdoba', 'X', 1),
(44, 6, 'Corrientes', 'W', 1),
(44, 6, 'Entre Ríos', 'E', 1),
(44, 6, 'Formosa', 'P', 1),
(44, 6, 'Jujuy', 'Y', 1),
(44, 6, 'La Pampa', 'L', 1),
(44, 6, 'La Rioja', 'F', 1),
(44, 6, 'Mendoza', 'M', 1),
(44, 6, 'Misiones', 'N', 1),
(44, 6, 'Neuquén', 'Q', 1),
(44, 6, 'Río Negro', 'R', 1),
(44, 6, 'Salta', 'A', 1),
(44, 6, 'San Juan', 'J', 1),
(44, 6, 'San Luis', 'D', 1),
(44, 6, 'Santa Cruz', 'Z', 1),
(44, 6, 'Santa Fe', 'S', 1),
(44, 6, 'Santiago del Estero', 'G', 1),
(44, 6, 'Tierra del Fuego', 'V', 1),
(44, 6, 'Tucumán', 'T', 1);

INSERT INTO `PREFIX_currency` (`name`, `iso_code`, `iso_code_num`, `sign`, `blank`, `conversion_rate`, `format`, `deleted`, `active`) VALUES
('Euro', 'EUR', '978', '€', 1, 1, 2, 0, 1), ('Dollar', 'USD', '840', '$', 0, 1.32, 1, 0, 1), ('Pound', 'GBP', '826', '£', 0, 0.8, 1, 0, 1);
/*('Yen', 'JPY', '392', '¥', 0, 113.14, 2, 0, 0),
('Lev', 'BGN', '975', 'лв', 1, 1.96, 2, 0, 0), ('Couronne', 'CZK', '203', 'Kč', 1, 24.58, 2, 0, 0), ('Couronne', 'DKK', '208', 'kr', 1, 7.45, 2, 0, 0),
('Couronne', 'EEK', '233', 'kr', 1, 15.65, 2, 0, 0), ('Forint', 'HUF', '348', 'Ft', 1, 279.65, 2, 0, 0), ('Litas', 'LTL', '440', 'Lt', 1, 3.45, 2, 0, 0),
('Lats letton', 'LVL', '428', 'Ls', 1, 0.71, 2, 0, 0), ('Zloty', 'PLN', '985', 'zł', 1, 3.94, 2, 0, 0), ('Leu', 'RON', '946', 'lei', 1, 4.26, 2, 0, 0),
('Couronne', 'SEK', '752', 'kr', 1, 9.13, 2, 0, 0), ('Franc Suisse', 'CHF', '756', 'CHF', 1, 1.32, 2, 0, 0), ('Couronne', 'NOK', '578', 'kr', 1, 7.90, 2, 0, 0),
('Kuna', 'HRK', '191', 'kn', 1, 7.28, 2, 0, 0), ('Rouble', 'RUB', '643', 'руб', 1, 41.46, 2, 0, 0), ('Livre', 'TRY', '949', 'TL', 1, 1.98, 2, 0, 0),
('Australian Dollar', 'AUD', '036', '$', 1, 1.40, 2, 0, 0), ('Réal', 'BRL', '986', 'R$', 1, 2.28, 2, 0, 0), ('Canadian Dollar', 'CAD', '124', '$', 1, 1.37, 2, 0, 0),
('Yuan renminbi', 'CNY', '156', '¥', 1, 8.96, 2, 0, 0), ('Hong Kong Dollar', 'HKD', '344', '$', 1, 10.37, 2, 0, 0), ('Rupiah', 'IDR', '360', 'Rp', 1, 11956.81, 2, 0, 0),
('Rupees', 'INR', '356', 'rupees', 1, 60.93, 2, 0, 0), ('Won', 'KRW', '410', '₩', 1, 1537.58, 2, 0, 0), ('Mexican Peso', 'MXN', '484', '$', 1, 16.96, 2, 0, 0),
('Ringgit', 'MYR', '458', 'RM', 1, 4.13, 2, 0, 0), ('New-Zeland Dollar', 'NZD', '554', '$', 1, 1.81, 2, 0, 0), ('Peso Phillipin', 'PHP', '608', 'Php', 1, 58.61, 2, 0, 0),
('Singapour Dollar', 'SGD', '702', '$', 1, 1.77, 2, 0, 0), ('Baht', 'THB', '764', '฿', 1, 40.96, 2, 0, 0), ('Rand', 'ZAR', '710', 'R', 1, 9.38, 2, 0, 0);*/

INSERT INTO `PREFIX_image_type` (`id_image_type`, `name`, `width`, `height`, `products`, `categories`, `manufacturers`, `suppliers`, `scenes`) VALUES
(1, 'small', 45, 45, 1, 1, 1, 1, 0),
(2, 'medium', 80, 80, 1, 1, 1, 1, 0),
(3, 'large', 300, 300, 1, 1, 1, 1, 0),
(4, 'thickbox', 600, 600, 1, 0, 0, 0, 0),
(5, 'category', 500, 150, 0, 1, 0, 0, 0),
(6, 'home', 129, 129, 1, 0, 0, 0, 0),
(7, 'large_scene', 556, 200, 0, 0, 0, 0, 1),
(8, 'thumb_scene', 161, 58, 0, 0, 0, 0, 1);

INSERT INTO `PREFIX_contact_lang` (`id_contact`, `id_lang`, `name`, `description`) VALUES
(1, 1, 'Webmaster', 'If a technical problem occurs on this website'),
(1, 2, 'Webmaster', 'Si un problème technique survient sur le site'),
(1, 3, 'Webmaster', 'Si se produce un problema técnico en el sitio'),
(1, 4, 'Webmaster', 'Falls ein technisches Problem auf der Webseite auftritt'),
(1, 5, 'Webmaster', 'Se nel sito interviene un problema tecnico'),
(2, 1, 'Customer service', 'For any question about a product, an order'),
(2, 2, 'Service client', 'Pour toute question ou réclamation sur une commande'),
(2, 3, 'Service client', 'Para cualquier pregunta o queja acerca de un pedido'),
(2, 4, 'Kundenservice', 'Bei Fragen oder Reklamationen zu einer Bestellung'),
(2, 5, 'Servizio clienti', 'Per qualsiasi domanda o reclamo riguardo ad un ordine');

INSERT INTO `PREFIX_discount_type` (`id_discount_type`) VALUES (1),(2),(3);
INSERT INTO `PREFIX_discount_type_lang` (`id_discount_type`, `id_lang`, `name`) VALUES
(1, 1, 'Discount on order (%)'),(2, 1, 'Discount on order (amount)'),(3, 1, 'Free shipping'),
(1, 2, 'Réduction sur la commande (%)'),(2, 2, 'Réduction sur la commande (montant)'),(3, 2, 'Frais de port gratuits'),
(1, 3, 'Descuento orden (%)'),(2, 3, 'Descuento (el orden de cantidad)'),(3, 3, 'Gastos de envío gratis'),
(1, 4, 'Preisnachlass auf die Bestellung (%)'),(2, 4, 'Preisnachlass auf die Bestellung (Betrag)'),(3, 4, 'Versandkosten gratis'),
(1, 5, 'Sconto sull’ordine (%)'),(2, 5, 'Sconto sull’ordine (importo)'),(3, 5, 'Spese di porto gratuite');

INSERT INTO `PREFIX_profile` (`id_profile`) VALUES (1);
INSERT INTO `PREFIX_profile_lang` (`id_profile`, `id_lang`, `name`) VALUES (1, 1, 'Administrator'),(1, 2, 'Administrateur'),(1, 3, 'Administrador'),(1, 4, 'Administrator'),(1, 5, 'Administrator');

INSERT INTO `PREFIX_tab` (`id_tab`, `class_name`, `id_parent`, `position`) VALUES (1, 'AdminCatalog', 0, 1),(2, 'AdminCustomers', 0, 2),(3, 'AdminOrders', 0, 3),
(4, 'AdminPayment', 0, 4),(5, 'AdminShipping', 0, 5),(6, 'AdminStats', 0, 6),(7, 'AdminModules', 0, 7),(29, 'AdminEmployees', 0, 8),(8, 'AdminPreferences', 0, 9),
(9, 'AdminTools', 0, 10),(82, 'AdminStores', 9, 11),(60, 'AdminTracking', 1, 1),(10, 'AdminManufacturers', 1, 2),(34, 'AdminSuppliers', 1, 3),(11, 'AdminAttributesGroups', 1, 4),
(36, 'AdminFeatures', 1, 5),(58, 'AdminScenes', 1, 6),(66, 'AdminTags', 1, 7),(68, 'AdminAttachments', 1, 7),(12, 'AdminAddresses', 2, 1),(63, 'AdminGroups', 2, 2),
(65, 'AdminCarts', 2, 3),(42, 'AdminInvoices', 3, 1),(55, 'AdminDeliverySlip', 3, 2),(47, 'AdminReturn', 3, 3),(49, 'AdminSlip', 3, 4),(59, 'AdminMessages', 3, 5),
(13, 'AdminStatuses', 3, 6),(54, 'AdminOrderMessage', 3, 7),(14, 'AdminDiscounts', 4, 4),(15, 'AdminCurrencies', 4, 1),(16, 'AdminTaxes', 4, 2),
(17, 'AdminCarriers', 5, 1),(46, 'AdminStates', 5, 2),(18, 'AdminCountries', 5, 3),(19, 'AdminZones', 5, 4),(20, 'AdminRangePrice', 5, 5),
(21, 'AdminRangeWeight', 5, 6),(51, 'AdminStatsConf', 6, 1),(61, 'AdminSearchEngines', 6, 2),(62, 'AdminReferrers', 6, 3),
(22, 'AdminModulesPositions', 7, 4),(30, 'AdminProfiles', 29, 1),(31, 'AdminAccess', 29, 2),(28, 'AdminContacts', 29, 3),(39, 'AdminContact', 8, 1),
(38, 'AdminAppearance', 8, 2),(56, 'AdminMeta', 8, 3),(27, 'AdminPPreferences', 8, 4),(24, 'AdminEmails', 8, 5),(26, 'AdminImages', 8, 6),(23, 'AdminDb', 8, 7),
(48, 'AdminPDF', 3, 8),(44, 'AdminLocalization', 8, 9),(67, 'AdminSearchConf', 8, 10),(32, 'AdminLanguages', 9, 1),(33, 'AdminTranslations', 9, 2),
(35, 'AdminTabs', 29, 3),(37, 'AdminQuickAccesses', 9, 4),(40, 'AdminAliases', 8, 5),(41, 'AdminImport', 9, 6),(52, 'AdminSubDomains', 9, 7),
(53, 'AdminBackup', 9, 8),(57, 'AdminCMSContent', 9, 9),(64, 'AdminGenerator', 9, 10),(43, 'AdminSearch', -1, 0),(69, 'AdminInformation', 9, 11),
(70, 'AdminPerformance', 8, 11),(71, 'AdminCustomerThreads', 29, 4),(72, 'AdminWebservice', 9, 12),(73, 'AdminStockMvt', 1, 9),
(80, 'AdminAddonsCatalog', 7, 1),(81, 'AdminAddonsMyAccount', 7, 2),(83, 'AdminThemes', 7, 3),(84, 'AdminGeolocalization', 8, 12),
(85, 'AdminTaxRulesGroup', 4, 3),(86, 'AdminLogs', 9, 13);

INSERT INTO `PREFIX_access` (`id_profile`, `id_tab`, `view`, `add`, `edit`, `delete`) (SELECT 1, id_tab, 1, 1, 1, 1 FROM PREFIX_tab);

INSERT INTO `PREFIX_tab_lang` (`id_lang`, `id_tab`, `name`) VALUES
(1, 1, 'Catalog'),(1, 2, 'Customers'),(1, 3, 'Orders'),(1, 4, 'Payment'),
(1, 5, 'Shipping'),(1, 6, 'Stats'),(1, 7, 'Modules'),(1, 8, 'Preferences'),(1, 9, 'Tools'),(1, 10, 'Manufacturers'),(1, 11, 'Attributes and Groups'),
(1, 12, 'Addresses'),(1, 13, 'Statuses'),(1, 14, 'Vouchers'),(1, 15, 'Currencies'),(1, 16, 'Taxes'),(1, 17, 'Carriers'),(1, 18, 'Countries'),
(1, 19, 'Zones'),(1, 20, 'Price Ranges'),(1, 21, 'Weight Ranges'),(1, 22, 'Positions'),(1, 23, 'Database'),(1, 24, 'E-mail'),(1, 26, 'Image'),
(1, 27, 'Products'),(1, 28, 'Contacts'),(1, 29, 'Employees'),(1, 30, 'Profiles'),(1, 31, 'Permissions'),(1, 32, 'Languages'),(1, 33, 'Translations'),
(1, 34, 'Suppliers'),(1, 35, 'Tabs'),(1, 36, 'Features'),(1, 37, 'Quick Access'),(1, 38, 'Appearance'),(1, 39, 'Contact Information'),(1, 40, 'Aliases'),
(1, 41, 'Import'),(1, 42, 'Invoices'),(1, 43, 'Search'),(1, 44, 'Localization'),(1, 46, 'States'),(1, 47, 'Merchandise Returns'),(1, 48, 'PDF'),
(1, 49, 'Credit Slips'),(1, 51, 'Settings'),(1, 52, 'Subdomains'),(1, 53, 'DB backup'),(1, 54, 'Order Messages'),
(1, 55, 'Delivery Slips'),(1, 56, 'SEO'),(1, 57, 'CMS'),(1, 58, 'Image Mapping'),(1, 59, 'Customer Messages'),(1, 60, 'Tracking'),
(1, 61, 'Search Engines'),(1, 62, 'Referrers'),(1, 63, 'Groups'),(1, 64, 'Generators'),(1, 65, 'Shopping Carts'),(1, 66, 'Tags'),(1, 67, 'Search'),
(1, 68, 'Attachments'),(1, 69, 'Configuration Information'),(1, 70, 'Performance'),(1, 71, 'Customer Service'),(1, 72, 'Webservice'),(1, 73, 'Stock Movements'),
(1, 80, 'Modules & Themes Catalog'),(1, 81, 'My Account'),(1, 82, 'Stores'),(1, 83, 'Themes'),(1, 84, 'Geolocalization'),(1, 85, 'Tax Rules'),(1, 86, 'Log');

INSERT INTO `PREFIX_tab_lang` (`id_lang`, `id_tab`, `name`) VALUES
(2, 1, 'Catalogue'),(2, 2, 'Clients'),(2, 3, 'Commandes'),(2, 4, 'Paiement'),(2, 5, 'Transport'),
(2, 6, 'Stats'),(2, 7, 'Modules'),(2, 8, 'Préférences'),(2, 9, 'Outils'),(2, 10, 'Fabricants'),(2, 11, 'Attributs et groupes'),(2, 12, 'Adresses'),(2, 13, 'Statuts'),
(2, 14, 'Bons de réduction'),(2, 15, 'Devises'),(2, 16, 'Taxes'),(2, 17, 'Transporteurs'),(2, 18, 'Pays'),(2, 19, 'Zones'),(2, 20, 'Tranches de prix'),
(2, 21, 'Tranches de poids'),(2, 22, 'Positions'),(2, 23, 'Base de données'),(2, 24, 'Emails'),(2, 26, 'Images'),(2, 27, 'Produits'),(2, 28, 'Contacts'),
(2, 29, 'Employés'),(2, 30, 'Profils'),(2, 31, 'Permissions'),(2, 32, 'Langues'),(2, 33, 'Traductions'),(2, 34, 'Fournisseurs'),(2, 35, 'Onglets'),
(2, 36, 'Caractéristiques'),(2, 37, 'Accès rapide'),(2, 38, 'Apparence'),(2, 39, 'Coordonnées'),(2, 40, 'Alias'),(2, 41, 'Import'),(2, 42, 'Factures'),
(2, 43, 'Recherche'),(2, 44, 'Localisation'),(2, 46, 'Etats'),(2, 47, 'Retours produits'),(2, 48, 'PDF'),(2, 49, 'Avoirs'),
(2, 51, 'Configuration'),(2, 52, 'Sous domaines'),(2, 53, 'Sauvegarde BDD'),(2, 54, 'Messages prédéfinis'),(2, 55, 'Bons de livraison'),
(2, 56, 'SEO'),(2, 57, 'CMS'),(2, 58, 'Scènes'),(2, 59, 'Messages clients'),(2, 60, 'Suivi'),(2, 61, 'Moteurs de recherche'),
(2, 62, 'Sites affluents'),(2, 63, 'Groupes'),(2, 64, 'Générateurs'),(2, 65, 'Paniers'),(2, 66, 'Tags'),(2, 67, 'Recherche'),
(2, 68, 'Documents joints'),(2, 69, 'Informations'),(2, 70, 'Performances'),(2, 71, 'SAV'),(2, 72, 'Service web'),(2, 73, 'Mouvements de Stock'),
(2, 80, 'Catalogue de modules et thèmes'),(2, 81, 'Mon compte'),(2, 82, 'Magasins'),(2, 83, 'Thèmes'),(2, 84, 'Géolocalisation'),(2, 85, 'Règles de taxes'),(2, 86, 'Log');

INSERT INTO `PREFIX_tab_lang` (`id_lang`, `id_tab`, `name`) VALUES
(3, 1, 'Catálogo'),(3, 2, 'Clientes'),(3, 3, 'Pedidos'),(3, 4, 'Pago'),(3, 5, 'Transporte'),
(3, 6, 'Estadísticas'),(3, 7, 'Módulos'),(3, 8, 'Preferencias'),(3, 9, 'Herramientas'),(3, 10, 'Fabricantes'),(3, 11, 'Atributos y grupos'),(3, 12, 'Direcciones'),
(3, 13, 'Estados'),(3, 14, 'Vales de descuento'),(3, 15, 'Divisas'),(3, 16, 'Impuestos'),(3, 17, 'Transportistas'),(3, 18, 'Países'),(3, 19, 'Zonas'),
(3, 20, 'Franja de precios'),(3, 21, 'Franja de pesos'),(3, 22, 'Posiciones'),(3, 23, 'Base de datos'),(3, 24, 'Emails'),(3, 26, 'Imágenes'),
(3, 27, 'Productos'),(3, 28, 'Contactos'),(3, 29, 'Empleados'),(3, 30, 'Perfiles'),(3, 31, 'Permisos'),(3, 32, 'Idiomas'),(3, 33, 'Traducciones'),
(3, 34, 'Proovedores'),(3, 35, 'Pestañas'),(3, 36, 'Características'),(3, 37, 'Acceso rápido'),(3, 38, 'Aspecto'),(3, 39, 'Datos'),(3, 40, 'Alias'),
(3, 41, 'Importar'),(3, 42, 'Facturas'),(3, 43, 'Búsqueda'),(3, 44, 'Ubicación'),(3, 46, 'Estados'),(3, 47, 'Devolución productos'),(3, 48, 'PDF'),
(3, 49, 'Vales'),(3, 51, 'Configuración'),(3, 52, 'Subcampos'),(3, 53, 'Copia de seguridad'),(3, 54, 'Mensajes de Orden'),
(3, 55, 'Albaranes de entrega'),(3, 56, 'SEO'),(3, 57, 'CMS'),(3, 58, 'Mapeo de la imagen'),(3, 59, 'Mensajes del cliente'),(3, 60, 'Rastreo'),
(3, 61, 'Motores de búsqueda'),(3, 62, 'Referido'),(3, 63, 'Grupos'),(3, 64, 'Generadores'),(3, 65, 'Carritos'),(3, 66, 'Etiquetas'),(3, 67, 'Búsqueda'),(3, 68, 'Adjuntos'),
(3, 69, 'Informations'),(3, 70, 'Rendimiento'),(3, 72, 'Web service'),(3, 71, 'Servicio al cliente'),(3, 82, 'Tiendas'),(3, 83, 'Temas'),(3, 84, 'Geolocalización'),(3, 85, 'Reglas de Impuestos'),(3, 86, 'Log');

INSERT INTO `PREFIX_tab_lang` (`id_lang`, `id_tab`, `name`) VALUES
(4, 1, 'Katalog'),(4, 2, 'Kunden'),(4, 3, 'Bestellungen'),(4, 4, 'Zahlung'),
(4, 5, 'Versandkosten'),(4, 6, 'Statistik'),(4, 7, 'Module'),(4, 8, 'Voreinstellungen'),(4, 9, 'Tools'),(4, 10, 'Hersteller'),(4, 11, 'Attribute und Gruppen'),
(4, 12, 'Adressen'),(4, 13, 'Status'),(4, 14, 'Gutscheine'),(4, 15, 'Währungen'),(4, 16, 'Steuern'),(4, 17, 'Lieferanten'),(4, 18, 'Länder'),
(4, 19, 'Zonen'),(4, 20, 'Preislagen'),(4, 21, 'Gewichtsklassen'),(4, 22, 'Positionen'),(4, 23, 'Datenbank'),(4, 24, 'E-Mail'),(4, 26, 'Bild'),
(4, 27, 'Produkte'),(4, 28, 'Kontakte'),(4, 29, 'Mitarbeiter'),(4, 30, 'Profile'),(4, 31, 'Berechtigungen'),(4, 32, 'Sprachen'),(4, 33, 'Übersetzungen'),
(4, 34, 'Zulieferer'),(4, 35, 'Tabs'),(4, 36, 'Funktionen'),(4, 37, 'Schnellzugriff'),(4, 38, 'Aussehen'),(4, 39, 'Kontaktinformation'),(4, 40, 'Alias'),
(4, 41, 'Import'),(4, 42, 'Rechnungen'),(4, 43, 'Suche'),(4, 44, 'Lokalisierung'),(4, 46, 'Staaten'),(4, 47, 'Warenrücksendungen'),(4, 48, 'PDF'),
(4, 49, 'Gutscheine'),(4, 51, 'Einstellungen'),(4, 52, 'Subdomains'),(4, 53, 'DB-Backup'),(4, 54, 'Bestellnachrichten'),
(4, 55, 'Lieferscheine'),(4, 56, 'SEO'),(4, 57, 'CMS'),(4, 58, 'Image Mapping'),(4, 59, 'Kundennachrichten'),(4, 60, 'Tracking'),
(4, 61, 'Suchmaschinen'),(4, 62, 'Referrer'),(4, 63, 'Gruppen'),(4, 64, 'Generatoren'),(4, 65, 'Warenkörbe'),(4, 66, 'Tags'),(4, 67, 'Suche'),
(4, 68, 'Anhänge'),(4, 69, 'Konfigurationsinformationen'),(4, 70, 'Leistung'),(4, 71, 'Kundenservice'),(4, 72, 'Webservice'),(4, 73, 'Lagerbewegungen'),
(4, 80, 'Module und Themenkatalog'),(4, 81, 'Mein Konto'),(4, 82, 'Shops'),(4, 83, 'Themen'),(4, 84, 'Geotargeting'),(4, 85, 'Steuerregeln'),(4, 86, 'Log');

INSERT INTO `PREFIX_tab_lang` (`id_lang`, `id_tab`, `name`) VALUES
(5, 1, 'Catalogo'),(5, 2, 'Clienti'),(5, 3, 'Ordini'),(5, 4, 'Pagamento'),
(5, 5, 'Spedizione'),(5, 6, 'Stat'),(5, 7, 'Moduli'),(5, 8, 'Preferenze'),(5, 9, 'Strumenti'),(5, 10, 'Produttori'),(5, 11, 'Attributi e Gruppi'),
(5, 12, 'Indirizzi'),(5, 13, 'Status'),(5, 14, 'Voucher'),(5, 15, 'Valute'),(5, 16, 'Tasse'),(5, 17, 'Corrieri'),(5, 18, 'Nazioni'),
(5, 19, 'Zone'),(5, 20, 'Fasce di prezzo'),(5, 21, 'Fasce di peso'),(5, 22, 'Posizioni'),(5, 23, 'Database'),(5, 24, 'E-mail'),(5, 26, 'Immagine'),
(5, 27, 'Prodotti'),(5, 28, 'Contatti'),(5, 29, 'Impiegati'),(5, 30, 'Profili'),(5, 31, 'Permessi'),(5, 32, 'Lingue'),(5, 33, 'Traduzioni'),
(5, 34, 'Fornitori'),(5, 35, 'Tab'),(5, 36, 'Caratteristiche'),(5, 37, 'Accesso rapido'),(5, 38, 'Aspetto'),(5, 39, 'Informazioni di contatto'),(5, 40, 'Alias'),
(5, 41, 'Importa'),(5, 42, 'Fatture'),(5, 43, 'Cerca'),(5, 44, 'Localizzazione'),(5, 46, 'Stati'),(5, 47, 'Resi merci'),(5, 48, 'PDF'),
(5, 49, 'Note di credito'),(5, 51, 'Impostazioni'),(5, 52, 'Sottodomini'),(5, 53, 'DB backup'),(5, 54, 'Messaggi ordine'),
(5, 55, 'Note di consegna'),(5, 56, 'SEO'),(5, 57, 'CMS'),(5, 58, 'Mappatura immagine'),(5, 59, 'Messaggi cliente'),(5, 60, 'Rintracciare'),
(5, 61, 'Motori di ricerca'),(5, 62, 'Referenti'),(5, 63, 'Gruppi'),(5, 64, 'Generatori'),(5, 65, 'Carrelli shopping'),(5, 66, 'Tag'),(5, 67, 'Cerca'),
(5, 68, 'Allegati'),(5, 69, 'Informazioni di configurazione'),(5, 70, 'Performance'),(5, 71, 'Servizio clienti'),(5, 72, 'Webservice'),(5, 73, 'Movimenti magazzino'),
(5, 80, 'Moduli & Temi catalogo'),(5, 81, 'Il mio Account'),(5, 82, 'Negozi'),(5, 83, 'Temi'),(5, 84, 'Geolocalizzazione'),(5, 85, 'Regimi fiscali'),(5, 86, 'Log');

INSERT IGNORE INTO `PREFIX_tab_lang` (`id_tab`, `id_lang`, `name`)
    (SELECT `id_tab`, id_lang, (SELECT tl.`name`
        FROM `PREFIX_tab_lang` tl
        WHERE tl.`id_lang` = (SELECT c.`value`
            FROM `PREFIX_configuration` c
            WHERE c.`name` = 'PS_LANG_DEFAULT' LIMIT 1) AND tl.`id_tab`=`PREFIX_tab`.`id_tab`)
    FROM `PREFIX_lang` CROSS JOIN `PREFIX_tab`);

INSERT INTO `PREFIX_quick_access` (`id_quick_access`, `link`, `new_window`) VALUES
(1, 'index.php', 0),(2, '../', 1),(3, 'index.php?tab=AdminCatalog&addcategory', 0),(4, 'index.php?tab=AdminCatalog&addproduct', 0),(5, 'index.php?tab=AdminDiscounts&adddiscount', 0);

INSERT INTO `PREFIX_quick_access_lang` (`id_quick_access`, `id_lang`, `name`) VALUES
(1, 1, 'Home'),(1, 2, 'Accueil'),(1, 3, 'Inicio'),(1, 4, 'Start'),(1, 5, 'Home page'),
(2, 1, 'My Shop'),(2, 2, 'Ma boutique'),(2, 3, 'Mi tienda'),(2, 4, 'Mein Shop'),(2, 5, 'Il mio negozio'),
(3, 1, 'New category'),(3, 2, 'Nouvelle catégorie'),(3, 3, 'Nueva categoría'),(3, 4, 'Neue Kategorie'),(3, 5, 'Nuova categoria'),
(4, 1, 'New product'),(4, 2, 'Nouveau produit'),(4, 3, 'Nuevo producto'),(4, 4, 'Neues Produkt'),(4, 5, 'Nuovo prodotto'),
(5, 1, 'New voucher'),(5, 2, 'Nouveau bon de réduction'),(5, 3, 'Nuevo cupón'),(5, 4, 'Neuer Ermäßigungsgutschein'),(5, 5, 'Nuovo buono sconto');

INSERT INTO `PREFIX_order_return_state` (`id_order_return_state`, `color`) VALUES (1, '#ADD8E6'),(2, '#EEDDFF'),(3, '#DDFFAA'),(4, '#FFD3D3'),(5, '#FFFFBB');

INSERT INTO `PREFIX_order_return_state_lang` (`id_order_return_state`, `id_lang`, `name`) VALUES
(1, 1, 'Waiting for confirmation'),(2, 1, 'Waiting for package'),(3, 1, 'Package received'),(4, 1, 'Return denied'),(5, 1, 'Return completed'),
(1, 2, 'En attente de confirmation'),(2, 2, 'En attente du colis'),(3, 2, 'Colis reçu'),(4, 2, 'Retour refusé'),(5, 2, 'Retour terminé'),
(1, 3, 'Pendiente de confirmación'),(2, 3, 'En espera de paquetes'),(3, 3, 'Paquetes recibidos'),(4, 3, 'Volver negó'),(5, 3, 'Diligenciados'),
(1, 4, 'Bestätigung wird erwartet'),(2, 4, 'Paket wird erwartet'),(3, 4, 'Paket erhalten'),(4, 4, 'Rücksendung abgelehnt'),(5, 4, 'Rücksendung beendet'),
(1, 5, 'In attesa di conferma'),(2, 5, 'In attesa del pacco'),(3, 5, 'Pacco ricevuto'),(4, 5, 'Restituzione non accettata'),(5, 5, 'Restituzione terminata');

INSERT INTO `PREFIX_meta` (`id_meta`, `page`) VALUES
(1, '404'),
(2, 'best-sales'),
(3, 'contact-form'),
(4, 'index'),
(5, 'manufacturer'),
(6, 'new-products'),
(7, 'password'),
(8, 'prices-drop'),
(9, 'sitemap'),
(10, 'supplier'),
(11, 'address'),
(12, 'addresses'),
(13, 'authentication'),
(14, 'cart'),
(15, 'discount'),
(16, 'history'),
(17, 'identity'),
(18, 'my-account'),
(19, 'order-follow'),
(20, 'order-slip'),
(21, 'order'),
(22, 'search'),
(23, 'stores');

INSERT INTO `PREFIX_meta_lang` (`id_meta`, `id_lang`, `title`, `description`, `keywords`, `url_rewrite`) VALUES
(1, 1, '404 error', 'This page cannot be found', 'error, 404, not found', 'page-not-found'),
(1, 2, 'Erreur 404', 'Cette page est introuvable', 'erreur, 404, introuvable', 'page-non-trouvee'),
(1, 3, 'Error 404', 'Esta página no se encuentra', 'error, 404, No se ha encontrado', 'pagina-no-encuentra'),
(2, 1, 'Best sales', 'Our best sales', 'best sales', 'best-sales'),
(2, 2, 'Meilleures ventes', 'Liste de nos produits les mieux vendus', 'meilleures ventes', 'meilleures-ventes'),
(2, 3, 'Los más vendidos', 'Lista de los de mayor venta de productos', 'los más vendidos', 'mas-vendidos'),
(3, 1, 'Contact us', 'Use our form to contact us', 'contact, form, e-mail', 'contact-us'),
(3, 2, 'Contactez-nous', 'Utilisez notre formulaire pour nous contacter', 'contact, formulaire, e-mail', 'contactez-nous'),
(3, 3, 'Contáctenos', 'Use nuestro formulario de contacto con nosotros', 'formulario de contacto, e-mail', 'contactenos'),
(4, 1, '', 'Shop powered by PrestaShop', 'shop, prestashop', ''),
(4, 2, '', 'Boutique propulsée par PrestaShop', 'boutique, prestashop', ''),
(4, 3, '', 'Shop powered by PrestaShop', 'tienda, prestashop', ''),
(5, 1, 'Manufacturers', 'Manufacturers list', 'manufacturer', 'manufacturers'),
(5, 2, 'Fabricants', 'Liste de nos fabricants', 'fabricants', 'fabricants'),
(5, 3, 'Fabricantes', 'Lista de Fabricantes', 'fabricantes', 'fabricantes'),
(6, 1, 'New products', 'Our new products', 'new, products', 'new-products'),
(6, 2, 'Nouveaux produits', 'Liste de nos nouveaux produits', 'nouveau, produit', 'nouveaux-produits'),
(6, 3, 'Nuevos Productos', 'Lista de nuestros nuevos productos', 'nuevo, productos', 'nuevos-productos'),
(7, 1, 'Forgot your password', 'Enter your e-mail address used to register in goal to get e-mail with your new password', 'forgot, password, e-mail, new, reset', 'password-recovery'),
(7, 2, 'Mot de passe oublié', 'Renseignez votre adresse e-mail afin de recevoir votre nouveau mot de passe.', 'mot de passe, oublié, e-mail, nouveau, regénération', 'mot-de-passe-oublie'),
(7, 3, 'Olvidaste tu contraseña', 'Ingrese su dirección de correo electrónico para recibir su nueva contraseña.', 'contraseña, has olvidado, e-mail, nuevo, regeneración', 'contrasena-olvidado'),
(8, 1, 'Prices drop', 'Our special products', 'special, prices drop', 'prices-drop'),
(8, 2, 'Promotions', 'Nos produits en promotion', 'promotion, réduction', 'promotions'),
(8, 3, 'Promociones', 'Nuestros productos promocionales', 'promoción, reducción', 'promocion'),
(9, 1, 'Sitemap', 'Lost ? Find what your are looking for', 'sitemap', 'sitemap'),
(9, 2, 'Plan du site', 'Perdu ? Trouvez ce que vous cherchez', 'plan, site', 'plan-du-site'),
(9, 3, 'Mapa del sitio', '¿Perdido? Encuentra lo que buscas', 'plan, sitio', 'mapa-del-sitio'),
(10, 1, 'Suppliers', 'Suppliers list', 'supplier', 'supplier'),
(10, 2, 'Fournisseurs', 'Liste de nos fournisseurs', 'fournisseurs', 'fournisseurs'),
(10, 3, 'Proveedores', 'Lista de Proveedores', 'proveedores', 'proveedores'),
(11, 1, 'Address', '', '', 'address'),
(11, 2, 'Adresse', '', '', 'adresse'),
(11, 3, 'Dirección', '', '', 'direccion'),
(12, 1, 'Addresses', '', '', 'addresses'),
(12, 2, 'Adresses', '', '', 'adresses'),
(12, 3, 'Direcciones', '', '', 'direcciones'),
(13, 1, 'Authentication', '', '', 'authentication'),
(13, 2, 'Authentification', '', '', 'authentification'),
(13, 3, 'Autenticación', '', '', 'autenticacion'),
(14, 1, 'Cart', '', '', 'cart'),
(14, 2, 'Panier', '', '', 'panier'),
(14, 3, 'Carro de la compra', '', '', 'carro-de-la-compra'),
(15, 1, 'Discount', '', '', 'discount'),
(15, 2, 'Bons de réduction', '', '', 'bons-de-reduction'),
(15, 3, 'Descuento', '', '', 'descuento'),
(16, 1, 'Order history', '', '', 'order-history'),
(16, 2, 'Historique des commandes', '', '', 'historique-des-commandes'),
(16, 3, 'Historial de pedidos', '', '', 'historial-de-pedidos'),
(17, 1, 'Identity', '', '', 'identity'),
(17, 2, 'Identité', '', '', 'identite'),
(17, 3, 'Identidad', '', '', 'identidad'),
(18, 1, 'My account', '', '', 'my-account'),
(18, 2, 'Mon compte', '', '', 'mon-compte'),
(18, 3, 'Mi Cuenta', '', '', 'mi-cuenta'),
(19, 1, 'Order follow', '', '', 'order-follow'),
(19, 2, 'Détails de la commande', '', '', 'details-de-la-commande'),
(19, 3, 'Devolución de productos', '', '', 'devolucion-de-productos'),
(20, 1, 'Order slip', '', '', 'order-slip'),
(20, 2, 'Avoirs', '', '', 'avoirs'),
(20, 3, 'Vales', '', '', 'vales'),
(21, 1, 'Order', '', '', 'order'),
(21, 2, 'Commande', '', '', 'commande'),
(21, 3, 'Carrito', '', '', 'carrito'),
(22, 1, 'Search', '', '', 'search'),
(22, 2, 'Recherche', '', '', 'recherche'),
(22, 3, 'Buscar', '', '', 'buscar'),
(23, 1, 'Stores', '', '', 'stores'),
(23, 2, 'Magasins', '', '', 'magasins'),
(23, 3, 'Tiendas', '', '', 'tiendas'),
(1, 4, 'Fehler 404', 'Seite wurde nicht gefunden', 'Fehler 404, nicht gefunden', 'Seite-nicht-gefunden'),
(2, 4, 'Verkaufshits', 'Unsere Verkaufshits', 'Verkaufshits', 'Verkaufshits'),
(3, 4, 'Kontaktieren Sie uns', 'Nutzen Sie unser Kontaktformular', 'Kontakt, Formular, E-Mail', 'Kontaktieren Sie uns'),
(4, 4, '', 'Shop powered by PrestaShop', 'Shop, prestashop', ''),
(5, 4, 'Hersteller', 'Herstellerliste', 'Hersteller', 'Hersteller'),
(6, 4, 'Neue Produkte', 'Unsere neuen Produkte', 'neu, Produkte', 'Neue-Produkte'),
(7, 4, 'Kennwort vergessen', 'Geben Sie die E-Mailadresse ein, die Sie zum Einloggen benutzen, damit Sie eine E-Mail mit dem neuen Kennwort erhalt', 'vergessen, Kennwort, E-Mail, neu, Reset', 'Kennwort Wiederherstellung'),
(8, 4, 'Preise fallen', 'Unsere Sonderangebote', 'besonders, Preise fallen', 'Preise-fallen'),
(9, 4, 'Sitemap', 'Verloren? Finden Sie, was Sie suchen', 'sitemap', 'sitemap'),
(10, 4, 'Zulieferer', 'Zuliefererliste', 'Zulieferer', 'Zulieferer'),
(11, 4, 'Adresse', '', '', 'Adresse'),
(12, 4, 'Adressen', '', '', 'Adressen'),
(13, 4, 'Authentifizierung', '', '', 'Authentifizierung'),
(14, 4, 'Warenkorb', '', '', 'Warenkorb'),
(15, 4, 'Discount', '', '', 'Discount'),
(16, 4, 'Bestellungsverlauf', '', '', 'Bestellungsverlauf'),
(17, 4, 'Kennung', '', '', 'Kennung'),
(18, 4, 'Mein Konto', '', '', 'mein-Konto'),
(19, 4, 'Bestellungsverfolgung', '', '', 'Bestellungsverfolgung'),
(20, 4, 'Bestellschein', '', '', 'Bestellschein'),
(21, 4, 'Bestellung', '', '', 'Bestellung'),
(22, 4, 'Suche', '', '', 'Suche'),
(23, 4, 'Shops', '', '', 'Shops'),
(1, 5, 'errore 404', 'Impossibile trovare questa pagina', 'errore, 404, non trovato', 'pagina-non-trovata'),
(2, 5, 'Vendite migliori', 'Le nostre vendite migliori', 'vendite migliori', 'vendite-migliori'),
(3, 5, 'Contattaci', 'Usa il nostro modulo per contattarci', 'contatto, modulo, e-mail', 'contattaci'),
(4, 5, '', 'Negozio powered by PrestaShop', 'negozio, prestashop', ''),
(5, 5, 'Produttori', 'Elenco produttori', 'produttore', 'produttori'),
(6, 5, 'Nuovi prodotti', 'I nostri nuovi prodotti', 'nuovi, prodotti', 'nuovi-prodotti'),
(7, 5, 'Hai dimenticato la password', 'Inserisci l\'indirizzo e-mail usato per registrarti per poter ottenere una e-mail with con la tua nuova password', 'dimenticato, password, e-mail, nuovo, reset', 'password-recupero'),
(8, 5, 'Riduzioni prezzi', 'I nostri prodotti speciali', 'speciali, riduzione prezzi', 'riduzione-prezzi'),
(9, 5, 'Mappa del sito', 'Ti sei perso? Trova quello che stai cercando', 'sitemap', 'sitemap'),
(10, 5, 'Fornitori', 'Elenco fornitori', 'fornitori', 'fornitore'),
(11, 5, 'Indirizzo', '', '', 'indirizzo'),
(12, 5, 'Indirizzi', '', '', 'indirizzi'),
(13, 5, 'Autenticazione', '', '', 'autenticazione'),
(14, 5, 'Carrello', '', '', 'carrello'),
(15, 5, 'Sconto', '', '', 'sconto'),
(16, 5, 'Storico ordine', '', '', 'storico-ordine'),
(17, 5, 'Identità', '', '', 'identità'),
(18, 5, 'Il mio account', '', '', 'il mio-account'),
(19, 5, 'Seguito ordine', '', '', 'seguito-ordine'),
(20, 5, 'Nota di ordine', '', '', 'nota di-ordine'),
(21, 5, 'Ordine', '', '', 'ordine'),
(22, 5, 'Cerca', '', '', 'cerca'),
(23, 5, 'Negozi', '', '', 'negozi');

/* Stats */
INSERT INTO `PREFIX_operating_system` (`name`) VALUES ('Windows XP'),('Windows Vista'),('MacOsX'),('Linux');
INSERT INTO `PREFIX_web_browser` (`name`) VALUES ('Safari'),('Firefox 2.x'),('Firefox 3.x'),('Opera'),('IE 6.x'),('IE 7.x'),('IE 8.x'),('Google Chrome');
INSERT INTO `PREFIX_page_type` (`id_page_type`, `name`) VALUES 
(13, 'authentication.php'),(11, 'best-sales.php'),(2, 'category.php'),(7, 'cms.php'),(12, 'contact-form.php'),(5, 'index.php'),(4, 'manufacturer.php'),
(3, 'order.php'),(10, 'prices-drop.php'),(1, 'product.php'),(8, 'search.php'),(14, 'sitemap.php'),(9, 'stores.php'),(6, 'supplier.php');
INSERT INTO `PREFIX_search_engine` (`server`,`getvar`)
VALUES  ('google','q'),('aol','q'),('yandex','text'),('ask.com','q'),('nhl.com','q'),('yahoo','p'),('baidu','wd'),
('lycos','query'),('exalead','q'),('search.live','q'),('voila','rdata'),('altavista','q'),('bing','q'),('daum','q'),
('eniro','search_word'),('naver','query'),('msn','q'),('netscape','query'),('cnn','query'),('about','terms'),('mamma','query'),
('alltheweb','q'),('virgilio','qs'),('alice','qs'),('najdi','q'),('mama','query'),('seznam','q'),('onet','qt'),('szukacz','q'),
('yam','k'),('pchome','q'),('kvasir','q'),('sesam','q'),('ozu','q'),('terra','query'),('mynet','q'),('ekolay','q'),('rambler','words');

/* SubDomains */
INSERT INTO `PREFIX_subdomain` (`id_subdomain`, `name`) VALUES (NULL, 'www');

/* CMS */
INSERT INTO `PREFIX_cms` (`id_cms`, `id_cms_category`, `position`, `active`) VALUES (1, 1, 0, 1), (2, 1, 1, 1), (3, 1, 2, 1), (4, 1, 3, 1), (5, 1, 4, 1);
INSERT INTO `PREFIX_cms_lang` (`id_cms`, `id_lang`, `meta_title`, `meta_description`, `meta_keywords`, `content`, `link_rewrite`) VALUES
(1, 1, 'Delivery', 'Our terms and conditions of delivery', 'conditions, delivery, delay, shipment, pack', '<h2>Shipments and returns</h2><h3>Your pack shipment</h3><p>Packages are generally dispatched within 2 days after receipt of payment and are shipped via UPS with tracking and drop-off without signature. If you prefer delivery by UPS Extra with required signature, an additional cost will be applied, so please contact us before choosing this method. Whichever shipment choice you make, we will provide you with a link to track your package online.</p><p>Shipping fees include handling and packing fees as well as postage costs. Handling fees are fixed, whereas transport fees vary according to total weight of the shipment. We advise you to group your items in one order. We cannot group two distinct orders placed separately, and shipping fees will apply to each of them. Your package will be dispatched at your own risk, but special care is taken to protect fragile objects.<br /><br />Boxes are amply sized and your items are well-protected.</p>', 'delivery'),
(1, 2, 'Livraison', 'Nos conditions générales de livraison', 'conditions, livraison, délais, transport, colis', '<h2>Livraisons et retours</h2><h3>Le transport de votre colis</h3><p>Les colis sont g&eacute;n&eacute;ralement exp&eacute;di&eacute;s en 48h apr&egrave;s r&eacute;ception de votre paiement. Le mode d''expédition standard est le Colissimo suivi, remis sans signature. Si vous souhaitez une remise avec signature, un co&ucirc;t suppl&eacute;mentaire s''applique, merci de nous contacter. Quel que soit le mode d''expédition choisi, nous vous fournirons d&egrave;s que possible un lien qui vous permettra de suivre en ligne la livraison de votre colis.</p><p>Les frais d''exp&eacute;dition comprennent l''emballage, la manutention et les frais postaux. Ils peuvent contenir une partie fixe et une partie variable en fonction du prix ou du poids de votre commande. Nous vous conseillons de regrouper vos achats en une unique commande. Nous ne pouvons pas grouper deux commandes distinctes et vous devrez vous acquitter des frais de port pour chacune d''entre elles. Votre colis est exp&eacute;di&eacute; &agrave; vos propres risques, un soin particulier est apport&eacute; au colis contenant des produits fragiles..<br /><br />Les colis sont surdimensionn&eacute;s et prot&eacute;g&eacute;s.</p>', 'livraison'),
(2, 1, 'Legal Notice', 'Legal notice', 'notice, legal, credits', '<h2>Legal</h2><h3>Credits</h3><p>Concept and production:</p><p>This Web site was created using <a href="http://www.prestashop.com">PrestaShop</a>&trade; open-source software.</p>', 'legal-notice'),
(2, 2, 'Mentions légales', 'Mentions légales', 'mentions, légales, crédits', '<h2>Mentions l&eacute;gales</h2><h3>Cr&eacute;dits</h3><p>Concept et production :</p><p>Ce site internet a &eacute;t&eacute; r&eacute;alis&eacute; en utilisant la solution open-source <a href="http://www.prestashop.com">PrestaShop</a>&trade; .</p>', 'mentions-legales'),
(3, 1, 'Terms and conditions of use', 'Our terms and conditions of use', 'conditions, terms, use, sell', '<h2>Your terms and conditions of use</h2><h3>Rule 1</h3><p>Here is the rule 1 content</p>\r\n<h3>Rule 2</h3><p>Here is the rule 2 content</p>\r\n<h3>Rule 3</h3><p>Here is the rule 3 content</p>', 'terms-and-conditions-of-use'),
(3, 2, 'Conditions d''utilisation', 'Nos conditions générales de ventes', 'conditions, utilisation, générales, ventes', '<h2>Vos conditions de ventes</h2><h3>Règle n°1</h3><p>Contenu de la règle numéro 1</p>\r\n<h3>Règle n°2</h3><p>Contenu de la règle numéro 2</p>\r\n<h3>Règle n°3</h3><p>Contenu de la règle numéro 3</p>', 'conditions-generales-de-ventes'),
(4, 1, 'About us', 'Learn more about us', 'about us, informations', '<h2>About us</h2>\r\n<h3>Our company</h3><p>Our company</p>\r\n<h3>Our team</h3><p>Our team</p>\r\n<h3>Informations</h3><p>Informations</p>', 'about-us'),
(4, 2, 'A propos', 'Apprenez-en d''avantage sur nous', 'à propos, informations', '<h2>A propos</h2>\r\n<h3>Notre entreprise</h3><p>Notre entreprise</p>\r\n<h3>Notre équipe</h3><p>Notre équipe</p>\r\n<h3>Informations</h3><p>Informations</p>', 'a-propos'),
(5, 1, 'Secure payment', 'Our secure payment mean', 'secure payment, ssl, visa, mastercard, paypal', '<h2>Secure payment</h2>\r\n<h3>Our secure payment</h3><p>With SSL</p>\r\n<h3>Using Visa/Mastercard/Paypal</h3><p>About this services</p>', 'secure-payment'),
(5, 2, 'Paiement sécurisé', 'Notre offre de paiement sécurisé', 'paiement sécurisé, ssl, visa, mastercard, paypal', '<h2>Paiement sécurisé</h2>\r\n<h3>Notre offre de paiement sécurisé</h3><p>Avec SSL</p>\r\n<h3>Utilisation de Visa/Mastercard/Paypal</h3><p>A propos de ces services</p>', 'paiement-securise'),
(1, 3, 'Entrega', 'Nuestras condiciones de entrega', 'condiciones, plazos de entrega, transporte, paquetería', '<h2><span id="result_box"><span style="background-color: #ffffff;" title="Livraisons et retours">shipping & Returns</span></span></h2>\r\n<h3><span id="result_box"><span style="background-color: #ffffff;" title="Le transport de votre colis">El transporte de su paquete</span></span></h3>\r\n<p><span id="result_box"><span style="background-color: #ffffff;" title="Les colis sont généralement expédiés en 48h après réception de votre paiement.">Los paquetes son generalmente enviados en 48 horas después de la recepción de su pago. </span><span style="background-color: #ffffff;" title="Le mode d''expédition standard est le Colissimo suivi, remis sans signature.">La moda es el estándar expédition Colissimo seguido, entrega sin firma. </span><span style="background-color: #ffffff;" title="Si vous souhaitez une remise avec signature, un coût supplémentaire s''applique, merci de nous contacter.">Si desea una entrega con la firma, un cargo adicional, gracias al contacto con nosotros. </span><span style="background-color: #ffffff;" title="Quel que soit le mode d''expédition choisi, nous vous fournirons dès que possible un lien qui vous permettra de suivre en ligne la livraison de votre colis.">Sea cual sea el método de envío seleccionado, vamos a presentar lo antes posible, un vínculo que le permite rastrear el envío en línea de su paquete.<br /><br /></span><span style="background-color: #ffffff;" title="Les frais d''expédition comprennent l''emballage, la manutention et les frais postaux.">Gastos de envío incluyen el embalaje, la manipulación y envío. </span><span style="background-color: #ffffff;" title="Ils peuvent contenir une partie fixe et une partie variable en fonction du prix ou du poids de votre commande.">Pueden contener un fijo y una parte variable basado en el precio o el peso de su solicitud. </span><span style="background-color: #ffffff;" title="Nous vous conseillons de regrouper vos achats en une unique commande.">Le recomendamos que para consolidar sus compras en un solo comando. </span><span style="background-color: #ffffff;" title="Nous ne pouvons pas grouper deux commandes distinctes et vous devrez vous acquitter des frais de port pour chacune d''entre elles.">No podemos grupo de dos órdenes distintos y hay que pagar gastos de envío para cada uno. </span><span style="background-color: #ffffff;" title="Votre colis est expédié à vos propres risques, un soin particulier est apporté au colis contenant des produits fragiles..">Su paquete es enviado a su propio riesgo, se presta especial atención a las parcelas que contienen objetos frágiles ..<br /><br /></span><span style="background-color: #ffffff;" title="Les colis sont surdimensionnés et protégés.">Los paquetes son de gran tamaño y protegidas.</span></span></p>', 'entrega'),
(2, 3, 'Aviso legal', 'Aviso legal', 'términos, condiciones y créditos fotográficos', '<h2><span id="result_box"><span style="background-color: #ffffff;" title="Mentions légales">Pie de imprenta</span></span></h2>\r\n<h2><span id="result_box"><span style="background-color: #ffffff;" title="Mentions légales"> </span></span><span id="result_box"><span style="background-color: #ffffff;" title="Crédits">Créditos</span></span></h2>\r\n<h3><span id="result_box"></span></h3>\r\n<p><span id="result_box"><span style="background-color: #ffffff;" title="Crédits"><br /></span><span style="background-color: #ffffff;" title="Concept et production :">Concepto y producción:<br /><br /></span><span style="background-color: #ffffff;" title="Ce site internet a été réalisé en utilisant la solution open-source PrestaShop™ .">Este sitio web fue creado utilizando la solución de código abierto <a href="http://www.prestashop.com" target="_blank">PrestaShop</a>™.</span></span></p>', 'aviso-legal'),
(3, 3, 'Condiciones de uso', 'Condiciones de uso', 'condiciones, el consumo, las ventas generales', '<h2><span id="result_box"><span style="background-color: #ffffff;" title="Vos conditions de ventes">Sus condiciones de venta</span></span></h2>\r\n<h3>Regla N º 1</h3>\r\n<p><span id="result_box"><span style="background-color: #ffffff;" title="Contenu de la règle numéro 1">Contenido de la Regla Número 1</span></span></p>\r\n<h3><span id="result_box"></span>Regla N º 2</h3>\r\n<p><span id="result_box"><span style="background-color: #ffffff;" title="Contenu de la règle numéro 2">Contenido de la Regla N º 2</span></span></p>\r\n<h3><span id="result_box"></span>Regla N º 3</h3>\r\n<p><span id="result_box"><span style="background-color: #ffffff;" title="Contenu de la règle numéro 3">Contenido de la Regla Número 3</span></span></p>', 'condiciones-de-uso'),
(4, 3, 'Sobre', 'Conozca más sobre nosotros', 'sobre, información', '<h2>Sobre</h2>', 'sobre'),
(5, 3, 'Pago seguro', 'Ofrecemos pago seguro', 'pago seguro, ssl, visa, mastercard, paypal', '<h2><span id="result_box"><span style="background-color: #ffffff;" title="Paiement sécurisé">Pago seguro</span></span></h2>\r\n<h3><span id="result_box"><span style="background-color: #ffffff;" title="Notre offre de paiement sécurisé">Ofrecemos pago seguro</span></span></h3>\r\n<p><span id="result_box"><span style="background-color: #ffffff;" title="Avec SSL">SSL</span></span></p>\r\n<h3><span id="result_box"><span style="background-color: #ffffff;" title="Utilisation de Visa/Mastercard/Paypal">Utilice Visa / Mastercard / Paypal</span></span></h3>\r\n<p><span id="result_box"><span style="background-color: #ffffff;" title="A propos de ces services">Acerca de estos servicios</span></span></p>', 'pago-seguro'),
(1, 4, 'Lieferung', 'Unsere Lieferbedingungen', 'Bedingungen, Lieferung, Frist, Versand, Verpackung', '<h2>Versand und Rücknahme</h2><h3>Ihre Versandverpackung</h3><p>Pakete werden normalerweise 2 Tage nach Zahlungseingang mit UPS mit Bestellverfolgemöglichkeit und Ablieferung ohne Unterschrift geliefert. Wenn Sie lieber eine UPS-Sendung per Einschreiben erhalten möchten, entstehen zusätzliche Kosten. Bitte kontaktieren Sie uns, bevor Sie dieses Liefermethode wählen. Wir senden Ihnen einen Link für die Bestellverfolgung unabhängig davon, welche Liefermethode Sie wählen.</p><p>Die Versandkosten beinhalten Lade- und Verpackungsgebühren sowie die Portokosten. Die Verladegebühren stehen fest, wobei Transportkosten schwanken, je nach Gesamtgewicht des Pakets. Wir raten Ihnen, mehrere Artikel in einer Bestellung zusammenzufassen. Wir können zwei verschiedene Bestellungen nicht zusammenlegen, und die Versandkosten werden separat für jede Bestellung gerechnet. Ihr Paket wird auf Ihr Risiko versandt, aber zerbrechliche Ware wird besonders sorgsam behandelt.<br /><br />Die Versandschachteln sind weit geschnitten und ihre Ware wird gut geschützt verpackt.</p>', 'Lieferung'),
(2, 4, 'Rechtliche Hinweise', 'Rechtliche Hinweise', 'Hinweise, rechtlich, Gutscheine', '<h2>Legal</h2><h3>Credits</h3><p>Konzept und Gestaltung:</p><p>Diese Webseite wurde hergestellt unter Verwendung von <a href="http://www.prestashop.com">PrestaShop</a>&trade; open-source software.</p>', 'Rechtliche Hinweise'),
(3, 4, 'Allgemeine Nutzungsbedingungen', 'Unsere allgemeinen Nutzungsbedingungen', 'Voraussetzungen, Bedingungen, nutzen, verkaufen', '<h2>Your terms and conditions of use</h2><h3>Rule 1</h3><p>Here is the rule 1 content</p>\r\n<h3>Rule 2</h3><p>Here is the rule 2 content</p>\r\n<h3>Rule 3</h3><p>Here is the rule 3 content</p>', 'Allgemeine Nutzungsbedingungen'),
(4, 4, 'Über uns', 'Learn more about us', 'über uns, Informationen', '<h2>About us</h2>\r\n<h3>Our company</h3><p>Our company</p>\r\n<h3>Our team</h3><p>Our team</p>\r\n<h3>Informations</h3><p>Informations</p>', 'über-uns'),
(5, 4, 'Sichere Zahlung', 'Unsere Sicherheits-Zahlungsmethoden', 'Sichere Zahlung, SSL, Visa, MasterCard, PayPal', '<h2>Secure payment</h2>\r\n<h3>Our secure payment</h3><p>With SSL</p>\r\n<h3>Using Visa/Mastercard/Paypal</h3><p>About this services</p>', 'sichere-Zahlung'),
(1, 5, 'Consegna', 'I nostri termini e condizioni di consegna', 'condizioni, consegna, tempo, spedizione, pacco', '<h2>Spedizioni e resi</h2><h3>Spedizione del tuo pacco</h3><p>I pacchi sono solitamente spediti entro 2 giorni dopo il ricevimento del pagamento e inviati tramite UPS con controllo e consegna senza firma. Se preferisci una consegna con UPS Extra con richiesta di firma, sarà applicato un costo aggiuntivo, pertanto contattaci prima di scegliere questo mezzo. Qualunque tipo di spedizione tu scelga, ti garantiremo un link per controllare online il percorso del tuo pacco.</p><p>Le spese di spedizione comprendono le spese di imballaggio e affrancatura. Le spese di imballaggio sono fisse, mentre quelle di trasporto variano in base al peso totale della spedizione. Ti consigliamo di raggruppare i tuoi articoli in un unico ordine. Non possiamo raggruppare due ordini distinti eseguiti separatamente, e ad ognuno di esso saranno applicate le spese di spedizione. Il tuo pacco sarà inviato sotto la tua responsabilità, ma un\'attenzione particolare è riservata agli oggetti fragili.<br /><br />Le scatole hanno dimensioni ragionevoli e i tuoi articoli sono ben protetti.</p>', 'consegna'),
(2, 5, 'Nota Legale', 'Nota legale', 'nota, legale, crediti', '<h2>Legale</h2><h3>Crediti</h3><p>Creazione e produzione:</p><p>Questo sito web è stato realizzato usando un software open-source<a href="http://www.prestashop.com">PrestaShop</a>&trade;.</p>', 'nota-legale'),
(3, 5, 'Termini e condizioni d\'uso', 'I nostri termini e condizioni d\'uso', 'condizioni, termini, uso, vendi', '<h2>I tuoi termini e condizioni d\'uso</h2><h3>Regola 1</h3><p>Ecco il contenuto della regola 1</p>\r\n<h3>Regola 2</h3><p>Ecco il contenuto della regola 2</p>\r\n<h3>Regola 3</h3><p>Ecco il contenuto della regola 3</p>', 'termini-e-condizioni-di-uso'),
(4, 5, 'Chi siamo', 'Per sapere chi siamo', 'chi siamo, informazioni', '<h2>Chi siamo</h2>\r\n<h3>La nostra azienda</h3><p>La nostra azienda</p>\r\n<h3>Il nostro team</h3><p>Il nostro team</p>\r\n<h3>Informazioni</h3><p>Informazioni</p>', 'chi-siamo'),
(5, 5, 'Pagamento sicuro', 'Il nostro mezzo di pagamento sicuro', 'pagamento sicuro, ssl, visa, mastercard, paypal', '<h2>Pagamento sicuro</h2>\r\n<h3>Il nostro pagamento sicuro</h3><p>Con SSL</p>\r\n<h3>Usando Visa/Mastercard/Paypal</h3><p>Cosa sono questi servizi</p>', 'pagamento-sicuro');

INSERT INTO `PREFIX_cms_category_lang` (`id_cms_category`, `id_lang`, `name`, `description`, `link_rewrite`, `meta_title`, `meta_keywords`, `meta_description`) VALUES
(1, 1, 'Home', '', 'home', NULL, NULL, NULL),
(1, 2, 'Accueil', '', 'home', NULL, NULL, NULL),
(1, 3, 'Inicio', '', 'home', NULL, NULL, NULL),
(1, 4, 'Start', '', 'Start', NULL, NULL, NULL),
(1, 5, 'Home', '', 'home', NULL, NULL, NULL);

INSERT INTO `PREFIX_cms_category` (`id_cms_category`, `id_parent`, `level_depth`, `active`, `date_add`, `date_upd`) VALUES(1, 0, 0, 1, NOW(), NOW());

/* Carrier */
INSERT INTO `PREFIX_carrier` (`id_carrier`, `id_tax_rules_group`, `name`, `active`, `deleted`, `shipping_handling`) VALUES (1, 0, 0, 1, 0, 0);

INSERT INTO `PREFIX_carrier_group` (`id_carrier`, `id_group`) VALUES (1, 1);

INSERT INTO `PREFIX_carrier_lang` (`id_carrier`, `id_lang`, `delay`) VALUES (1, 1, 'Pick up in-store'),(1, 2, 'Retrait au magasin'),(1, 3, 'Recogida en la tienda'),(1, 4, 'Abholung im Geschäft'),(1, 5, 'Ritiro in magazzino');

INSERT INTO `PREFIX_carrier_zone` (`id_carrier`, `id_zone`) VALUES (1, 1);

INSERT INTO `PREFIX_configuration` (`name`, `value`, `date_add`, `date_upd`) VALUES	('PS_CARRIER_DEFAULT', '1', NOW(), NOW());

/* Timezone */
INSERT INTO `PREFIX_timezone` (`name`) VALUES ('Africa/Abidjan'),('Africa/Accra'),('Africa/Addis_Ababa'),('Africa/Algiers'),
('Africa/Asmara'),('Africa/Asmera'),('Africa/Bamako'),('Africa/Bangui'),('Africa/Banjul'),('Africa/Bissau'),('Africa/Blantyre'),
('Africa/Brazzaville'),('Africa/Bujumbura'),('Africa/Cairo'),('Africa/Casablanca'),('Africa/Ceuta'),('Africa/Conakry'),('Africa/Dakar'),
('Africa/Dar_es_Salaam'),('Africa/Djibouti'),('Africa/Douala'),('Africa/El_Aaiun'),('Africa/Freetown'),('Africa/Gaborone'),('Africa/Harare'),
('Africa/Johannesburg'),('Africa/Kampala'),('Africa/Khartoum'),('Africa/Kigali'),('Africa/Kinshasa'),('Africa/Lagos'),('Africa/Libreville'),
('Africa/Lome'),('Africa/Luanda'),('Africa/Lubumbashi'),('Africa/Lusaka'),('Africa/Malabo'),('Africa/Maputo'),('Africa/Maseru'),
('Africa/Mbabane'),('Africa/Mogadishu'),('Africa/Monrovia'),('Africa/Nairobi'),('Africa/Ndjamena'),('Africa/Niamey'),('Africa/Nouakchott'),
('Africa/Ouagadougou'),('Africa/Porto-Novo'),('Africa/Sao_Tome'),('Africa/Timbuktu'),('Africa/Tripoli'),('Africa/Tunis'),('Africa/Windhoek'),
('America/Adak'),('America/Anchorage '),('America/Anguilla'),('America/Antigua'),('America/Araguaina'),('America/Argentina/Buenos_Aires'),
('America/Argentina/Catamarca'),('America/Argentina/ComodRivadavia'),('America/Argentina/Cordoba'),('America/Argentina/Jujuy'),
('America/Argentina/La_Rioja'),('America/Argentina/Mendoza'),('America/Argentina/Rio_Gallegos'),('America/Argentina/Salta'),
('America/Argentina/San_Juan'),('America/Argentina/San_Luis'),('America/Argentina/Tucuman'),('America/Argentina/Ushuaia'),('America/Aruba'),
('America/Asuncion'),('America/Atikokan'),('America/Atka'),('America/Bahia'),('America/Barbados'),('America/Belem'),('America/Belize'),
('America/Blanc-Sablon'),('America/Boa_Vista'),('America/Bogota'),('America/Boise'),('America/Buenos_Aires'),('America/Cambridge_Bay'),
('America/Campo_Grande'),('America/Cancun'),('America/Caracas'),('America/Catamarca'),('America/Cayenne'),('America/Cayman'),('America/Chicago'),
('America/Chihuahua'),('America/Coral_Harbour'),('America/Cordoba'),('America/Costa_Rica'),('America/Cuiaba'),('America/Curacao'),
('America/Danmarkshavn'),('America/Dawson'),('America/Dawson_Creek'),('America/Denver'),('America/Detroit'),('America/Dominica'),
('America/Edmonton'),('America/Eirunepe'),('America/El_Salvador'),('America/Ensenada'),('America/Fort_Wayne'),('America/Fortaleza'),
('America/Glace_Bay'),('America/Godthab'),('America/Goose_Bay'),('America/Grand_Turk'),('America/Grenada'),('America/Guadeloupe'),
('America/Guatemala'),('America/Guayaquil'),('America/Guyana'),('America/Halifax'),('America/Havana'),('America/Hermosillo'),
('America/Indiana/Indianapolis'),('America/Indiana/Knox'),('America/Indiana/Marengo'),('America/Indiana/Petersburg'),
('America/Indiana/Tell_City'),('America/Indiana/Vevay'),('America/Indiana/Vincennes'),('America/Indiana/Winamac'),('America/Indianapolis'),
('America/Inuvik'),('America/Iqaluit'),('America/Jamaica'),('America/Jujuy'),('America/Juneau'),('America/Kentucky/Louisville'),
('America/Kentucky/Monticello'),('America/Knox_IN'),('America/La_Paz'),('America/Lima'),('America/Los_Angeles'),('America/Louisville'),
('America/Maceio'),('America/Managua'),('America/Manaus'),('America/Marigot'),('America/Martinique'),('America/Mazatlan'),('America/Mendoza'),
('America/Menominee'),('America/Merida'),('America/Mexico_City'),('America/Miquelon'),('America/Moncton'),('America/Monterrey'),
('America/Montevideo'),('America/Montreal'),('America/Montserrat'),('America/Nassau'),('America/New_York'),('America/Nipigon'),
('America/Nome'),('America/Noronha'),('America/North_Dakota/Center'),('America/North_Dakota/New_Salem'),('America/Panama'),
('America/Pangnirtung'),('America/Paramaribo'),('America/Phoenix'),('America/Port-au-Prince'),('America/Port_of_Spain'),('America/Porto_Acre'),
('America/Porto_Velho'),('America/Puerto_Rico'),('America/Rainy_River'),('America/Rankin_Inlet'),('America/Recife'),('America/Regina'),
('America/Resolute'),('America/Rio_Branco'),('America/Rosario'),('America/Santarem'),('America/Santiago'),('America/Santo_Domingo'),
('America/Sao_Paulo'),('America/Scoresbysund'),('America/Shiprock'),('America/St_Barthelemy'),('America/St_Johns'),('America/St_Kitts'),
('America/St_Lucia'),('America/St_Thomas'),('America/St_Vincent'),('America/Swift_Current'),('America/Tegucigalpa'),('America/Thule'),
('America/Thunder_Bay'),('America/Tijuana'),('America/Toronto'),('America/Tortola'),('America/Vancouver'),('America/Virgin'),('America/Whitehorse'),
('America/Winnipeg'),('America/Yakutat'),('America/Yellowknife'),('Antarctica/Casey'),('Antarctica/Davis'),('Antarctica/DumontDUrville'),
('Antarctica/Mawson'),('Antarctica/McMurdo'),('Antarctica/Palmer'),('Antarctica/Rothera'),('Antarctica/South_Pole'),('Antarctica/Syowa'),
('Antarctica/Vostok'),('Arctic/Longyearbyen'),('Asia/Aden'),('Asia/Almaty'),('Asia/Amman'),('Asia/Anadyr'),('Asia/Aqtau'),('Asia/Aqtobe'),
('Asia/Ashgabat'),('Asia/Ashkhabad'),('Asia/Baghdad'),('Asia/Bahrain'),('Asia/Baku'),('Asia/Bangkok'),('Asia/Beirut'),('Asia/Bishkek'),
('Asia/Brunei'),('Asia/Calcutta'),('Asia/Choibalsan'),('Asia/Chongqing'),('Asia/Chungking'),('Asia/Colombo'),('Asia/Dacca'),('Asia/Damascus'),
('Asia/Dhaka'),('Asia/Dili'),('Asia/Dubai'),('Asia/Dushanbe'),('Asia/Gaza'),('Asia/Harbin'),('Asia/Ho_Chi_Minh'),('Asia/Hong_Kong'),('Asia/Hovd'),
('Asia/Irkutsk'),('Asia/Istanbul'),('Asia/Jakarta'),('Asia/Jayapura'),('Asia/Jerusalem'),('Asia/Kabul'),('Asia/Kamchatka'),('Asia/Karachi'),
('Asia/Kashgar'),('Asia/Kathmandu'),('Asia/Katmandu'),('Asia/Kolkata'),('Asia/Krasnoyarsk'),('Asia/Kuala_Lumpur'),('Asia/Kuching'),('Asia/Kuwait'),
('Asia/Macao'),('Asia/Macau'),('Asia/Magadan'),('Asia/Makassar'),('Asia/Manila'),('Asia/Muscat'),('Asia/Nicosia'),('Asia/Novosibirsk'),('Asia/Omsk'),
('Asia/Oral'),('Asia/Phnom_Penh'),('Asia/Pontianak'),('Asia/Pyongyang'),('Asia/Qatar'),('Asia/Qyzylorda'),('Asia/Rangoon'),('Asia/Riyadh'),
('Asia/Saigon'),('Asia/Sakhalin'),('Asia/Samarkand'),('Asia/Seoul'),('Asia/Shanghai'),('Asia/Singapore'),('Asia/Taipei'),('Asia/Tashkent'),
('Asia/Tbilisi'),('Asia/Tehran'),('Asia/Tel_Aviv'),('Asia/Thimbu'),('Asia/Thimphu'),('Asia/Tokyo'),('Asia/Ujung_Pandang'),('Asia/Ulaanbaatar'),
('Asia/Ulan_Bator'),('Asia/Urumqi'),('Asia/Vientiane'),('Asia/Vladivostok'),('Asia/Yakutsk'),('Asia/Yekaterinburg'),('Asia/Yerevan'),
('Atlantic/Azores'),('Atlantic/Bermuda'),('Atlantic/Canary'),('Atlantic/Cape_Verde'),('Atlantic/Faeroe'),('Atlantic/Faroe'),('Atlantic/Jan_Mayen'),
('Atlantic/Madeira'),('Atlantic/Reykjavik'),('Atlantic/South_Georgia'),('Atlantic/St_Helena'),('Atlantic/Stanley'),('Australia/ACT'),
('Australia/Adelaide'),('Australia/Brisbane'),('Australia/Broken_Hill'),('Australia/Canberra'),('Australia/Currie'),('Australia/Darwin'),
('Australia/Eucla'),('Australia/Hobart'),('Australia/LHI'),('Australia/Lindeman'),('Australia/Lord_Howe'),('Australia/Melbourne'),('Australia/North'),
('Australia/NSW'),('Australia/Perth'),('Australia/Queensland'),('Australia/South'),('Australia/Sydney'),('Australia/Tasmania'),('Australia/Victoria'),
('Australia/West'),('Australia/Yancowinna'),('Europe/Amsterdam'),('Europe/Andorra'),('Europe/Athens'),('Europe/Belfast'),('Europe/Belgrade'),
('Europe/Berlin'),('Europe/Bratislava'),('Europe/Brussels'),('Europe/Bucharest'),('Europe/Budapest'),('Europe/Chisinau'),('Europe/Copenhagen'),
('Europe/Dublin'),('Europe/Gibraltar'),('Europe/Guernsey'),('Europe/Helsinki'),('Europe/Isle_of_Man'),('Europe/Istanbul'),('Europe/Jersey'),
('Europe/Kaliningrad'),('Europe/Kiev'),('Europe/Lisbon'),('Europe/Ljubljana'),('Europe/London'),('Europe/Luxembourg'),('Europe/Madrid'),('Europe/Malta'),
('Europe/Mariehamn'),('Europe/Minsk'),('Europe/Monaco'),('Europe/Moscow'),('Europe/Nicosia'),('Europe/Oslo'),('Europe/Paris'),('Europe/Podgorica'),
('Europe/Prague'),('Europe/Riga'),('Europe/Rome'),('Europe/Samara'),('Europe/San_Marino'),('Europe/Sarajevo'),('Europe/Simferopol'),('Europe/Skopje'),
('Europe/Sofia'),('Europe/Stockholm'),('Europe/Tallinn'),('Europe/Tirane'),('Europe/Tiraspol'),('Europe/Uzhgorod'),('Europe/Vaduz'),('Europe/Vatican'),
('Europe/Vienna'),('Europe/Vilnius'),('Europe/Volgograd'),('Europe/Warsaw'),('Europe/Zagreb'),('Europe/Zaporozhye'),('Europe/Zurich'),
('Indian/Antananarivo'),('Indian/Chagos'),('Indian/Christmas'),('Indian/Cocos'),('Indian/Comoro'),('Indian/Kerguelen'),('Indian/Mahe'),('Indian/Maldives'),
('Indian/Mauritius'),('Indian/Mayotte'),('Indian/Reunion'),('Pacific/Apia'),('Pacific/Auckland'),('Pacific/Chatham'),('Pacific/Easter'),('Pacific/Efate'),
('Pacific/Enderbury'),('Pacific/Fakaofo'),('Pacific/Fiji'),('Pacific/Funafuti'),('Pacific/Galapagos'),('Pacific/Gambier'),('Pacific/Guadalcanal'),
('Pacific/Guam'),('Pacific/Honolulu'),('Pacific/Johnston'),('Pacific/Kiritimati'),('Pacific/Kosrae'),('Pacific/Kwajalein'),('Pacific/Majuro'),
('Pacific/Marquesas'),('Pacific/Midway'),('Pacific/Nauru'),('Pacific/Niue'),('Pacific/Norfolk'),('Pacific/Noumea'),('Pacific/Pago_Pago'),('Pacific/Palau'),
('Pacific/Pitcairn'),('Pacific/Ponape'),('Pacific/Port_Moresby'),('Pacific/Rarotonga'),('Pacific/Saipan'),('Pacific/Samoa'),('Pacific/Tahiti'),
('Pacific/Tarawa'),('Pacific/Tongatapu'),('Pacific/Truk'),('Pacific/Wake'),('Pacific/Wallis'),('Pacific/Yap'),('Brazil/Acre'),('Brazil/DeNoronha'),
('Brazil/East'),('Brazil/West'),('Canada/Atlantic'),('Canada/Central'),('Canada/East-Saskatchewan'),('Canada/Eastern'),('Canada/Mountain'),
('Canada/Newfoundland'),('Canada/Pacific'),('Canada/Saskatchewan'),('Canada/Yukon'),('CET'),('Chile/Continental'),('Chile/EasterIsland'),('CST6CDT'),
('Cuba'),('EET'),('Egypt'),('Eire'),('EST'),('EST5EDT'),('Etc/GMT'),('Etc/GMT+0'),('Etc/GMT+1'),('Etc/GMT+10'),('Etc/GMT+11'),('Etc/GMT+12'),
('Etc/GMT+2'),('Etc/GMT+3'),('Etc/GMT+4'),('Etc/GMT+5'),('Etc/GMT+6'),('Etc/GMT+7'),('Etc/GMT+8'),('Etc/GMT+9'),('Etc/GMT-0'),('Etc/GMT-1'),
('Etc/GMT-10'),('Etc/GMT-11'),('Etc/GMT-12'),('Etc/GMT-13'),('Etc/GMT-14'),('Etc/GMT-2'),('Etc/GMT-3'),('Etc/GMT-4'),('Etc/GMT-5'),('Etc/GMT-6'),
('Etc/GMT-7'),('Etc/GMT-8'),('Etc/GMT-9'),('Etc/GMT0'),('Etc/Greenwich'),('Etc/UCT'),('Etc/Universal'),('Etc/UTC'),('Etc/Zulu'),('Factory'),('GB'),
('GB-Eire'),('GMT'),('GMT+0'),('GMT-0'),('GMT0'),('Greenwich'),('Hongkong'),('HST'),('Iceland'),('Iran'),('Israel'),('Jamaica'),('Japan'),('Kwajalein'),
('Libya'),('MET'),('Mexico/BajaNorte'),('Mexico/BajaSur'),('Mexico/General'),('MST'),('MST7MDT'),('Navajo'),('NZ'),('NZ-CHAT'),('Poland'),('Portugal'),
('PRC'),('PST8PDT'),('ROC'),('ROK'),('Singapore'),('Turkey'),('UCT'),('Universal'),('US/Alaska'),('US/Aleutian'),('US/Arizona'),('US/Central'),
('US/East-Indiana'),('US/Eastern'),('US/Hawaii'),('US/Indiana-Starke'),('US/Michigan'),('US/Mountain'),('US/Pacific'),('US/Pacific-New'),('US/Samoa'),
('UTC'),('W-SU'),('WET'),('Zulu');

INSERT INTO `PREFIX_group` (`id_group`, `reduction`, `date_add`, `date_upd`) VALUES	(1, 0, NOW(), NOW());

INSERT INTO `PREFIX_group_lang` (`id_group`, `id_lang`, `name`) VALUES	(1, 1, 'Default'),(1, 2, 'Défaut'),(1, 3, 'Predeterminado'),(1, 4, 'Fehler'),(1, 5, 'Default');

INSERT INTO `PREFIX_category_group` (`id_category`, `id_group`) VALUES (1, 1);
INSERT INTO `PREFIX_configuration` (`name`, `value`, `date_add`, `date_upd`) VALUES ('PS_TAX_ADDRESS_TYPE', 'id_address_delivery', NOW(), NOW());

INSERT INTO `PREFIX_stock_mvt_reason` (`id_stock_mvt_reason`, `date_add`, `date_upd`) VALUES
(1, NOW(), NOW()), (2, NOW(), NOW()), (3, NOW(), NOW());
INSERT INTO `PREFIX_stock_mvt_reason_lang` (`id_stock_mvt_reason`, `id_lang`, `name`) VALUES
(1, 1, 'Order'),
(1, 2, 'Commande'),
(1, 3, 'Order'),
(1, 4, 'Bestellung'),
(1, 5, 'Ordine'),
(2, 1, 'Missing Stock Movement'),
(2, 2, 'Mouvement de stock manquant'),
(2, 3, 'Missing Stock Movement'),
(2, 4, 'Lagerbewegung nicht stattgefunden'),
(2, 5, 'Movimento di merce mancante'),
(3, 1, 'Restocking'),
(3, 2, 'Réassort'),
(3, 3, 'Restocking'),
(3, 4, 'Auffüllung'),
(3, 5, 'Riassortimento');

