<?php

require_once(dirname(__FILE__).'/../../config/config.inc.php');
require_once(dirname(__FILE__).'/../../init.php');
require_once(dirname(__FILE__).'/WishList.php');

if ($cookie->isLogged())
{
	$id_wishlist = Tools::getValue('id_wishlist');
	if (empty($id_wishlist) === false)
	{
		$products = WishList::getProductByIdCustomer($id_wishlist, $cookie->id_customer, $cookie->id_lang);
		$bought = WishList::getBoughtProduct($id_wishlist);
		for ($i = 0; $i < sizeof($products); ++$i)
		{
			$obj = new Product(intval($products[$i]['id_product']), false, intval($cookie->id_lang));
			if (!Validate::isLoadedObject($obj))
				continue;
			else
			{
				if ($products[$i]['id_product_attribute'] != 0)
				{
					$attrgrps = $obj->getAttributesGroups(intval($cookie->id_lang));
					foreach ($attrgrps AS $attrgrp)
						if ($attrgrp['id_product_attribute'] == intval($products[$i]['id_product_attribute']))
						{
							$products[$i]['cover'] = $obj->id.'-'.$attrgrp['id_image'];
							break;
						}
				}
				else
				{
					$images = $obj->getImages(intval($cookie->id_lang));
					foreach ($images AS $k => $image)
						if ($image['cover'])
						{
							$products[$i]['cover'] = $obj->id.'-'.$image['id_image'];
							break;
						}
				}
				if (!isset($products[$i]['cover']))
					$products[$i]['cover'] = Language::getIsoById($cookie->id_lang).'-default';
			}
			$products[$i]['bought'] = false;
			for ($j = 0, $k = 0; $j < sizeof($bought); ++$j)
			{
				if ($bought[$j]['id_product'] == $products[$i]['id_product'] AND
					$bought[$j]['id_product_attribute'] == $products[$i]['id_product_attribute'])
					$products[$i]['bought'][$k++] = $bought[$j];
			}
		}
		
		$productBoughts = array();
		
		foreach ($products as $product)
			if (sizeof($product['bought']))
				$productBoughts[] = $product;
		$smarty->assign('products', $products);
		$smarty->assign('productsBoughts', $productBoughts);
		$smarty->assign('id_wishlist', $id_wishlist);
	}
}

$smarty->display(dirname(__FILE__).'/managewishlist.tpl');
