<?php

class BlockMyAccount extends Module
{
	public function __construct()
	{
		$this->name = 'blockmyaccount';
		$this->tab = 'Blocks';
		$this->version = 1.2;

		/* The parent construct is required for translations */
		parent::__construct();

		$this->page = basename(__FILE__, '.php');
		$this->displayName = $this->l('My Account block');
		$this->description = $this->l('Displays a block with links relative to user account');
	}

	function install()
	{
		if (!parent::install() OR !$this->registerHook('leftColumn'))
			return false;
		return true;
	}

	function hookLeftColumn($params)
	{
		global $smarty;
		
		if (!$params['cookie']->isLogged())
			return false;
		$smarty->assign(array(
			'voucherAllowed' => intval(Configuration::get('PS_VOUCHERS')),
			'returnAllowed' => intval(Configuration::get('PS_ORDER_RETURN')),
			'HOOK_CUSTOMER_ACCOUNT' => Module::hookExec('customerAccount')
		));
		return $this->display(__FILE__, $this->name.'.tpl');
	}

	function hookRightColumn($params)
	{
		return $this->hookLeftColumn($params);
	}

}

?>
