{*************************************************************************************************************************************}
{* IMPORTANT : If you change some data here, you have to report these changes in the ./blockcart-json.js (to let ajaxCart available) *}
{*************************************************************************************************************************************}

{if $ajax_allowed}
<script type="text/javascript" src="{$base_dir}js/jquery/iutil.prestashop-modifications.js"></script>
{* to perfectly play the tranfert animation, the script ifx.js have to be called here, but it create a method conflit with jquery.serialScroll.js file *}
<script type="text/javascript" src="{$base_dir}js/jquery/ifxtransfer.js"></script>
<script type="text/javascript" src="{$base_dir}modules/blockcart/ajax-cart.js"></script>
{/if}

<!-- MODULE Block cart -->
<div id="cart_block" class="block exclusive">
	<h4>
		<a href="{$base_dir_ssl}order.php">{l s='Cart' mod='blockcart'}</a>
		{if $ajax_allowed}
		<span id="block_cart_expand" {if $colapseExpandStatus eq 'expanded'}class="hidden"{/if}>&nbsp;</span>
		<span id="block_cart_collapse" {if $colapseExpandStatus eq 'collapsed' || !isset($colapseExpandStatus)}class="hidden"{/if}>&nbsp;</span>
		{/if}
	</h4>
	<div class="block_content">
	<!-- block summary -->
	<div id="cart_block_summary" class="{if $colapseExpandStatus eq 'expanded' || !$ajax_allowed}collapsed{else}expanded{/if}">
		<span class="ajax_cart_quantity">{if $cart_qties > 0}{$cart_qties}{/if}</span>
		<span class="ajax_cart_product_txt_s{if $cart_qties < 2} hidden{/if}">{l s='products' mod='blockcart'}</span>
		<span class="ajax_cart_product_txt{if $cart_qties != 1} hidden{/if}">{l s='product' mod='blockcart'}</span>
		<span class="ajax_cart_total">{if $cart_qties > 0}{convertPrice price=$cart->getOrderTotal(true)}{/if}</span>
		<span class="ajax_cart_no_product">{if $cart_qties == 0}{l s='(empty)' mod='blockcart'}{/if}</span>
	</div>
	<!-- block list of products -->
	<div id="cart_block_list" class="{if $colapseExpandStatus eq 'expanded' || !$ajax_allowed}expanded{else}collapsed{/if}">
	{if $products}
		<dl class="products">
		{foreach from=$products item=product name=myLoop}
			<dt id="cart_block_product_{$product.id_product}{if $product.id_product_attribute}_{$product.id_product_attribute}{/if}" class="{if $smarty.foreach.myLoop.first}first_item{elseif $smarty.foreach.myLoop.last}last_item{else}item{/if}">
				<span class="quantity-formated"><span class="quantity">{$product.cart_quantity}</span>x</span>
				<a class="cart_block_product_name" href="{$link->getProductLink($product.id_product, $product.link_rewrite)}" title="{$product.name|escape:htmlall:'UTF-8'}">{$product.name|escape:htmlall:'UTF-8'|truncate:30}</a>
				<a class="ajax_cart_block_remove_link" href="{$base_dir}cart.php?delete&amp;id_product={$product.id_product}&amp;ipa={$product.id_product_attribute}&amp;token={$static_token}" title="{l s='remove this product from my cart'}">&nbsp;</a>
				<span class="price">{displayWtPrice p="`$product.price_wt*$product.cart_quantity`"}</span>
			</dt>
			{if isset($product.attributes_small)}
			<dd id="cart_block_combination_of_{$product.id_product}{if $product.id_product_attribute}_{$product.id_product_attribute}{/if}" class="{if $smarty.foreach.myLoop.first}first_item{elseif $smarty.foreach.myLoop.last}last_item{else}item{/if}">
				<a href="{$link->getProductLink($product.id_product, $product.link_rewrite)}" title="{l s='Product detail'}">{$product.attributes_small}</a>
			</dd>
			{/if}
		{/foreach}
		</dl>
	{/if}
		<p {if $products}class="hidden"{/if} id="cart_block_no_products">{l s='No products' mod='blockcart'}</p>
		
		{if $discounts|@count > 0}<table id="vouchers">
			<tbody>
			{foreach from=$discounts item=discount}
				<tr id="bloc_cart_voucher_{$discount.id_discount}">
					<td class="name" title="{$discount.description}">{$discount.name|cat:' : '|cat:$discount.description|truncate:18:'...':true:false}</td>
					<td class="price">-{convertPrice price=$discount.value_real}</td>
					<td class="delete"><a href="{$base_dir_ssl}order.php?deleteDiscount={$discount.id_discount}" title="{l s='Delete'}"><img src="{$img_dir}icon/delete.gif" alt="{l s='Delete'}" class="icon" /></a></td>
				</tr>
			{/foreach}
			</tbody>
		</table>
		{/if}
		
		<p id="cart-prices">
			<span>{l s='Shipping' mod='blockcart'}</span>
			<span id="cart_block_shipping_cost" class="price ajax_cart_shipping_cost">{$shipping_cost}</span>
			<br/>
			{if $show_wrapping}
			<span>{l s='Wrapping' mod='blockcart'}</span>
			<span id="cart_block_wrapping_cost" class="price">{$wrapping_cost}</span>
			<br/>
            {/if}
			<span>{l s='Total' mod='blockcart'}</span>
			<span id="cart_block_total" class="price ajax_block_cart_total">{$total}</span>
		</p>
		<p id="cart-buttons">
			<a href="{$base_dir_ssl}order.php" class="button_small" title="{l s='Cart' mod='blockcart'}">{l s='Cart' mod='blockcart'}</a>
			<a href="{$base_dir_ssl}order.php?step=1" id="button_order_cart" class="exclusive" title="{l s='Check out' mod='blockcart'}">{l s='Check out' mod='blockcart'}</a>
		</p>
	</div>
	</div>
</div>
<!-- /MODULE Block cart -->
