<?php

/**
  * Connection class, Connection.php
  * Connection management
  * @category classes
  *
  * @author PrestaShop <support@prestashop.com>
  * @copyright PrestaShop
  * @license http://www.opensource.org/licenses/osl-3.0.php Open-source licence 3.0
  * @version 1.0
  *
  */

class Connection  extends ObjectModel
{
	/** @var integer */
	public $id_connections;
	
	/** @var integer */
	public $id_customer;

	/** @var string */
	public $ip_address;

	/** @var string */	
	public $date;

	protected	$fieldsRequired = array ('id_customer', 'ip_address', 'date');	
	protected	$fieldsValidate = array ('id_customer' => 'isUnsignedId', 'ip_address' => 'isUnsignedId');

	/* MySQL does not allow 'connections' for a table name */ 
	protected 	$table = 'connections';
	protected 	$identifier = 'id_connections';
	
	public function getFields()
	{
		parent::validateFields();

		$fields['id_customer'] = intval($this->id_customer);
		$fields['ip_address'] = pSQL($this->ip_address);
		
		return $fields;
	}	
}

?>