<?php

/**
  * Access class, Access.php
  * Access
  * @category classes
  *
  * @author PrestaShop <support@prestashop.com>
  * @copyright PrestaShop
  * @license http://www.opensource.org/licenses/osl-3.0.php Open-source licence 3.0
  * @version 0.8
  *
  */

class		Access extends ObjectModel
{
	/** @var integer */
	public $id_access;

	/** @var integer */
	public $id_profile;

	/** @var integer */
	public $id_tab;

	/** @var bool */
	public $view;

	/** @var bool */
	public $add;

	/** @var bool */
	public $edit;

	/** @var bool */
	public $delete;

	/** @var array tabs */
	private	$tabs;

	/** @var array profiles */
	private	$profiles;

	/** @var array accesses */
	private	$accesses = array();

	protected	$fieldsRequired = array ();
	protected	$fieldsValidate = array ('id_profile' => 'isUnsignedId', 'id_tab' => 'isUnsignedId', 'view' => 'isBool', 'add' => 'isBool', 'edit' => 'isBool', 'delete' => 'isBool');

	protected 	$table = 'access';
	protected 	$identifier = 'id_access';

	public function getFields()
	{
		parent::validateFields();

		$fields['id_profile'] = intval($this->id_profile);
		$fields['view'] = intval ($this->view);
		$fields['add'] = intval($this->add);
		$fields['edit'] = intval($this->edit);
		$fields['delete'] = intval($this->delete);

		return $fields;
	}

	/**
	 * Initialize access (for a new tab for example)
	 * @param integer $id_tab Tab id
	 * $return bool Succes
	 */
	static public function initAccess($id_tab)
	{
	 	/* Cookie's loading */
	 	global $cookie;
	 	if (!is_object($cookie) OR !$cookie->profile)
	 		return false;
	 	/* Profile selection */
	 	$profiles = Db::getInstance()->ExecuteS('SELECT `id_profile` FROM '._DB_PREFIX_.'profile');
	 	if (!$profiles OR empty($profiles))
	 		return false;
	 	/* Query definition */
	 	$query = 'INSERT INTO `'._DB_PREFIX_.'access` VALUES ';
	 	foreach ($profiles AS $profile)
	 	{
	 	 	$rights = ((intval($profile['id_profile']) == 1 OR intval($profile['id_profile']) == $cookie->profile) ? 1 : 0);
	 	 	$query .= ($profile === $profiles[0] ? '' : ', ').'(NULL, '.$profile['id_profile'].', '.$id_tab.', '.$rights.', '.$rights.', '.$rights.', '.$rights.')';
	 	}
	 	return Db::getInstance()->Execute($query);
	}


	/**
	 * Remove access (for a deleted tab for example)
	 * @param integer $id_tab Tab id
	 * $return bool Succes
	 */
	static public function removeAccess($id_tab)
	{
	 	return Db::getInstance()->Execute('DELETE FROM '._DB_PREFIX_.'access WHERE `id_tab` = '.intval($id_tab));
	}


	/**
	 * Get Access for a profile and a specific tab
	 *
	 * @param integer profile id
	 * @param integer tab id
	 * @return array accesses
	 */
	public	function getProfileAccess($id_profile, $id_tab)
	{
	 	/* Accesses selection */
	 	$this->access = Db::getInstance()->getRow('
		SELECT `view`, `add`, `edit`, `delete`
		FROM `'._DB_PREFIX_.'access`
		WHERE `id_profile` = '.intval($id_profile).' AND `id_tab` = '.intval($id_tab));

		return $this->access;
	}

	/**
	 * Get Accesses for a profile
	 *
	 * @param string profile id
	 * @return array accesses
	 */
	public	function getProfileAccesses($id_profile)
	{
	 	/* Accesses selection */
	 	$this->accesses = Db::getInstance()->ExecuteS('
		SELECT `id_access`, `id_tab`, `view`, `add`, `edit`, `delete`
		FROM `'._DB_PREFIX_.'access`
		WHERE `id_profile` = '.intval($id_profile));

	 	$result = array();
	 	/* For each access */
	 	if (!$this->accesses)
	 	{
		 	$this->_error[] = 'No access for this profile';
		 	return false;
	 	}
		foreach($this->accesses AS $access) {
		 	/* If it is the first time we meet this tab we prepare it */
		 	if (!isset($result[$access['id_tab']]))
		 		$result[$access['id_tab']] = array();
			$result[$access['id_tab']] = $access;
		}

		return $result;
	}
}
?>