<?php

require_once(dirname(__FILE__).'/config/config.inc.php');
require_once(dirname(__FILE__).'/init.php');
$errors = array();

$orderTotal = $cart->getOrderTotal(true, 1);

$cartDiscounts = $cart->getDiscounts();
foreach ($cartDiscounts AS $k => $cartDiscount)
	if ($error = $cart->checkDiscountValidity(new Discount(intval($cartDiscount['id_discount'])), $cartDiscounts, $orderTotal, $cart->getProducts()))
		$cart->deleteDiscount(intval($cartDiscount['id_discount']));

$add = Tools::getIsset('add') ? 1 : 0;
$delete = Tools::getIsset('delete') ? 1 : 0;

if (Configuration::get('PS_TOKEN_ENABLE') == 1 &&
	strcasecmp(Tools::getToken(false), Tools::getValue('token')) &&
	$cookie->isLogged() === true)
	$errors[] = Tools::displayError('invalid token');

//update the cart...
if ($add OR Tools::getIsset('update') OR $delete)
{
	//get the values
 	$idProduct = intval(Tools::getValue('id_product'), NULL);
	$idProductAttribute = intval(Tools::getValue('id_product_attribute', Tools::getValue('ipa')));
	$qty = intval(abs(Tools::getValue('qty', 1)));

	if (!$idProduct)
		$errors[] = Tools::displayError('product not found');
	else
	{
		$producToAdd = new Product(intval($idProduct), false, intval($cookie->id_lang));

		if ((!$producToAdd->id OR !$producToAdd->active) AND !$delete)
			$errors[] = Tools::displayError('product is no longer available');
		else
		{
			if ($idProductAttribute AND is_numeric($idProductAttribute))
			{
				if (!$delete AND !$producToAdd->isAvailableWhenOutOfStock($producToAdd->out_of_stock) AND !Attribute::checkAttributeQty(intval($idProductAttribute), intval($qty)))
					$errors[] = Tools::displayError('product is no longer available');
			}
			elseif ($producToAdd->hasAttributes() AND !$delete)
			{
				$idProductAttribute = Product::getDefaultAttribute(intval($producToAdd->id));
				if (!$idProductAttribute)
					Tools::redirectAdmin($link->getProductLink($producToAdd));
				else
					if (!$delete and !$producToAdd->isAvailableWhenOutOfStock($producToAdd->out_of_stock) AND !Attribute::checkAttributeQty(intval($idProductAttribute), intval($qty)))
						$errors[] = Tools::displayError('product is no longer available');
			}
			elseif (!$delete and !$producToAdd->checkQty(intval($qty)))
					$errors[] = Tools::displayError('product is no longer available');

			if ($add AND (intval($producToAdd->reduction_price) OR intval($producToAdd->reduction_percent) OR $producToAdd->on_sale))
			{
				$discounts = $cart->getDiscounts();
				foreach($discounts as $discount)
					if (!$discount['cumulable_reduction'])
						$errors[] = Tools::displayError('cannot add this product because current voucher doesn\'t allow additional discounts');
			}

			if (!sizeof($errors))
			{
				if ($add AND $qty >= 0)
				{
					if (!isset($cart->id) OR !$cart->id)
					{
					    $cart->add();
					    if ($cart->id)
							$cookie->id_cart = intval($cart->id);
					}
					$result = $cart->updateQty(intval($qty), intval($idProduct), intval($idProductAttribute), Tools::getValue('op', 'up'));
					if (!$result)
					{
						$errors[] = Tools::displayError('you already have the maximum quantity available for this product');
					}
				}
				elseif ($delete)
				{
					if (Cart::getNbProducts($cart->id) == 1)
					{
						$discounts = $cart->getDiscounts();
						foreach($discounts as $discount)
						{
							$discountObj = new Discount(intval($discount['id_discount']), intval($cookie->id_lang));
							if ($tmpError = $cart->checkDiscountValidity($discountObj, $discounts, $cart->getOrderTotal(true, 1), $cart->getProducts()))
								$errors[] = $tmpError;
							else
								$cart->deleteDiscount(intval($discount['id_discount']));
						}
					}
					$cart->deleteProduct(intval($idProduct), intval($idProductAttribute));
					if (!Cart::getNbProducts(intval($cart->id)))
					{
						$cart->id_carrier = 0;
						$cart->update();
					}
				}
			}
			if (!sizeof($errors))
			{
			 	$queryString = Tools::safeOutput(Tools::getValue('query', NULL));
				if ($queryString AND !Configuration::get('PS_CART_REDIRECT'))
					Tools::redirect('search.php?search='.$queryString);
				if (isset($_SERVER['HTTP_REFERER']))
				{
					ereg('http(s?)://(.*)/(.*)', $_SERVER['HTTP_REFERER'], $regs);
					if (isset($regs[3]) AND !Configuration::get('PS_CART_REDIRECT') AND Tools::getValue('ajax') != 'true')
						Tools::redirect($regs[3]);
				}
			}
		}
	}
}

//if cart.php is called by ajax
if (Tools::getValue('ajax') == 'true')
{
	require_once(_PS_MODULE_DIR_.'/blockcart/blockcart-ajax.php');
}
else
{
	if (sizeof($errors))
	{
		require_once(dirname(__FILE__).'/header.php');
		$smarty->assign('errors', $errors);
		$smarty->display(_PS_THEME_DIR_.'errors.tpl');
		require_once(dirname(__FILE__).'/footer.php');
	}
	else
	{
		Tools::redirect('order.php');
	}
}
?>
