<?php

/**
  * Password recuperation for employees account, password.php
  * @category admin
  *
  * @author PrestaShop <support@prestashop.com>
  * @copyright PrestaShop
  * @license http://www.opensource.org/licenses/osl-3.0.php Open-source licence 3.0
  * @version 1.0
  *
  */

define('PS_ADMIN_DIR', getcwd());

/* Disable automatic login redirection */
$noLogin = true;
include(PS_ADMIN_DIR.'/../config/config.inc.php');
$errors = array();


$cookie = new Cookie('psAdmin', substr($_SERVER['PHP_SELF'], strlen(__PS_BASE_URI__), -10));

switch (strtolower(Tools::setCookieLanguage()))
{
	case 'fr':
		$l = array(
		'Administration panel' => 'Panneau d\'administration',
		'There is 1 error' => 'Il y a 1 erreur', 
		'Forgot your password!' => 'Mot de passe oubli&eacute; !', 
		'Your password has been e-mailed to you' => 'Votre mot de passe vous a &eacute;t&eacute; envoy&eacute; par e-mail', 
		'back to login home' => 'retour &agrave; la page de connexion', 
		'Please, enter your e-mail address' => 'Merci d\'entrer votre adresse e-mail', 
		'(the one you wrote during your registration) in order to receive your access codes by e-mail' => '(celle que vous avez entr&eacute;e lors de votre inscription) afin de recevoir vos codes d\'acc&egrave;s par e-mail',
		'Send' => 'Envoyer', 
		'Your new admin password' => 'Votre nouveau mot de passe admin'
		);
	break;
	case 'en':
	default:
		$l = array(
		'Administration panel' => 'Back Office',
		'There is 1 error' => 'There is 1 error', 
		'Forgot your password!' => 'Forgot your password!', 
		'Your password has been e-mailed to you' => 'Your password has been e-mailed to you', 
		'back to login home' => 'back to login home', 
		'Please, enter your e-mail address' => 'Please, enter your e-mail address', 
		'(the one you wrote during your registration) in order to receive your access codes by e-mail' => '(the one you wrote during your registration) in order to receive your access codes by e-mail',
		'Send' => 'Send', 
		'Your new admin password' => 'Your new admin password'
		);
}

if (isset($_POST['Submit']))
{
	$errors = array();
	if (empty($_POST['email']))
		$errors[] = Tools::displayError('e-mail is empty');
	elseif (!Validate::isEmail($_POST['email']))
		$errors[] = Tools::displayError('invalid e-mail address');
	else
	{
		$employee = new Employee();
		if (!$employee->getByemail($_POST['email']) OR !$employee)
			$errors[] = Tools::displayError('this account doesn\'t exist');
		else
		{
			$pwd = Tools::passwdGen();
			$employee->passwd = md5(pSQL(_COOKIE_KEY_.$pwd));
			$result = $employee->update();
			if (!$result)
				$errors[] = Tools::displayError('an error occurred during your password change');
			else
			{
				Mail::Send(intval($cookie->id_lang), 'password', 'Your new admin password', array('{email}' => $employee->email, '{lastname}' => $employee->lastname, '{firstname}' => $employee->firstname, '{passwd}' => $pwd), $employee->email, $employee->firstname.' '.$employee->lastname);
				$confirmation = 'ok';
			}
		}
	}
}

echo '
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="fr" lang="fr">
<head>
	<meta http-equiv="content-type" content="text/html; charset=utf-8" />
	<link type="text/css" rel="stylesheet" href="../css/login.css" />
	<title>PrestaShop&trade; - '.$l['Administration panel'].'</title>
</head>
<body><div id="container">';
if (sizeof($errors))
{
	echo '<div id="error">
	<h3>'.$l['There is 1 error'].'</h3>
	<ol>';
	foreach ($errors AS $error)
		echo '<li>'.$error.'</li>';
	echo '</ol>
	</div>';
}		
echo '
	<div id="login">
		<form action="" method="post">
			<div class="page-title center">'.$l['Forgot your password!'].'</div><br />';
if (isset($confirmation))
	echo '	<br />
			<div style="font-weight: bold;">'.$l['Your password has been e-mailed to you'].'.</div>
			<div style="margin: 2em 0 0 0; text-align: right;"><a href="index.php">> '.$l['back to login home'].'</a></div>';
else
	echo '	<span style="font-weight: bold;">'.$l['Please, enter your e-mail address'].' </span>
			'.$l['(the one you wrote during your registration) in order to receive your access codes by e-mail'].'.<br />
			<input type="text" name="email" class="input" />
			<div>
				<div id="submit"><input type="submit" name="Submit" value="'.$l['Send'].'" class="button" /></div>
				<div id="lost">&nbsp;</div>
			</div>
		</form>
	</div>
</div></body></html>';

?>
