<?php

/**
  * Homepage and main page for admin panel, index.php
  * @category admin
  *
  * @author PrestaShop <support@prestashop.com>
  * @copyright PrestaShop
  * @license http://www.opensource.org/licenses/osl-3.0.php Open-source licence 3.0
  * @version 0.8
  *
  */

define('PS_ADMIN_DIR', getcwd());

include(PS_ADMIN_DIR.'/../config/config.inc.php');
include(PS_ADMIN_DIR.'/functions.php');
include(PS_ADMIN_DIR.'/toolbar.php');
include(PS_ADMIN_DIR.'/header.inc.php');

global $tabName;

function lindex($string)
{
	global $lindex;
	return (is_array($lindex) AND key_exists($string, $lindex)) ? $lindex[$string] : $string;
}

switch (strtolower(Language::getIsoById(intval($cookie->id_lang))))
{
	case 'fr':
		$lindex = array(
		'Welcome to your Back Office!' => 'Bienvenue sur votre panneau d\'administration !',
		'Please use tabs menu to navigate into your admin panel !' => 'Merci d\'utiliser les onglets du menu afin de naviguer dans votre panneau d\'administration !',
		'Your shop' => 'Votre boutique',
		'Total categories' => 'Nombre de cat&eacute;gories',
		'Total products' => 'Nombre de produits',
		'Total customers' => 'Nombre de clients',
		'Total orders' => 'Nombre de commandes',
		'PrestaShop live!' => 'PrestaShop en direct !',
		'RSS stream inaccessible' => 'RSS stream inaccessible',
		'http://www.php.net/manual/en/ref.filesystem.php' => 'http://fr.php.net/manual/fr/ref.filesystem.php',
		'more infos' => 'plus d\'infos',
		'To read the PrestaShop news, you need to activate the <b>allow_url_fopen</b> directive in your <b>php.ini</b> conf file.' => 'Pour lire l\'actualit&eacute; de PrestaShop, vous devez activer la directive <b>allow_url_fopen</b> dans votre fichier de conf <b>php.ini</b>.',
		'If you don\'t know how to do that, please contact your host administrator !' => 'Si vous ne savez pas comment proc&eacute;der, merci de contacter l\'administrateur de votre h&eacute;bergeur !',
		'Administration panel' => 'Panneau d\'administration',
		'New PrestaShop update avalaible' => 'Une Nouvelle version de PrestaShop est disponible',
		'Download' => 'Telecharger la',
		);
	break;
}

if ($tab)
{
	if ($id_tab = checkingTab($tab))
	{
		$tabs = array();
		recursiveTab($id_tab);
		$tabs = array_reverse($tabs);
		echo '<div class="path_bar"><img src="../img/admin/prefs.gif" style="margin-right:10px" /><a href="?token='.Tools::getAdminToken($tab.intval(Tab::getIdFromClassName($tab)).intval($cookie->id_employee)).'">'.lindex('Back Office').'</a>';
		foreach ($tabs AS $key => $item)
			echo ' >> <img src="../img/t/'.$item['id_tab'].'.gif" style="margin-right:5px">'.((sizeof($tabs) - 1 > $key) ? '<a href="?tab='.$item['class_name'].'&token='.Tools::getAdminToken($item['class_name'].intval($item['id_tab']).intval($cookie->id_employee)).'">' : '').$item['name'].((sizeof($tabs) - 1 > $key) ? '</a>' : '');
		echo '</div>';

		if (Validate::isLoadedObject($adminObj))
			if (!$adminObj->checkToken())
				return;

		/* Filter memorization */
		if (isset($_POST) AND !empty($_POST) AND isset($adminObj->table))
			foreach ($_POST AS $key => $value)
				if (is_array($adminObj->table))
				{
					foreach ($adminObj->table AS $table)
						if (strncmp($key, $table.'Filter_', 7) === 0 OR strncmp($key, 'submitFilter', 12) === 0)
							$cookie->$key = is_array($value) ? $value[0] : $value;
				}
				elseif (strncmp($key, $adminObj->table.'Filter_', 7) === 0 OR strncmp($key, 'submitFilter', 12) === 0)
					$cookie->$key = is_array($value) ? $value[0] : $value;
		if (isset($_GET) AND !empty($_GET) AND isset($adminObj->table))
			foreach ($_GET AS $key => $value)
				if (is_array($adminObj->table))
				{
					foreach ($adminObj->table AS $table)
						if (strncmp($key, $table.'OrderBy', 7) === 0 OR strncmp($key, $table.'Orderway', 8) === 0)
							$cookie->$key = $value;
				}
				elseif (strncmp($key, $adminObj->table.'OrderBy', 7) === 0 OR strncmp($key, $adminObj->table.'Orderway', 12) === 0)
					$cookie->$key = $value;

		$adminObj->displayConf();
		$adminObj->postProcess();
		$adminObj->displayErrors();
		$adminObj->display();
	}
}
else /* Else display homepage */
{
	echo '
	<img src="../img/logo.jpg" alt="Logo" title="Logo" /><br /><br />
	<h2>'.lindex('Welcome to your Back Office!').'</h2>
	'.lindex('Please use tabs menu to navigate into your admin panel !').'
	<br /><br /><br />';
	
	if (@ini_get('allow_url_fopen') AND $update = checkPSVersion())
		echo '<div class="warning warn" style="margin-bottom:30px;"><h3>'.lindex('New PrestaShop update avalaible').' : <a style="text-decoration: underline;" href="'.$update['link'].'">'.lindex('Download').'&nbsp;'.$update['name'].'</a> !</h3></div>';
    elseif (!@ini_get('allow_url_fopen'))
    {
		echo '<p>'.lindex('Update check unavailable').'</p>';
		echo '<p>&nbsp;</p>';
		echo '<p>'.lindex('To get Prestashop update warnings, you need to activate the <b>allow_url_fopen</b> directive in your <b>php.ini</b> conf file.').' [<a href="'.lindex('http://www.php.net/manual/en/ref.filesystem.php').'">'.lindex('more infos').'</a>]</p>';
		echo '<p>'.lindex('If you don\'t know how to do that, please contact your host administrator !').'</p><br>';
	}
	
	echo '<fieldset style="width: 200px;">
		<legend><img src="../img/admin/tab-stats.gif" alt="Your shop" title="" /> '.lindex('Your shop').'</legend>
		<p>'.lindex('Total categories').': <b>'.intval(Tools::getCategoriesTotal()).'</b></p>
		<p>'.lindex('Total products').': <b>'.intval(Tools::getProductsTotal()).'</b></p>
		<p>'.lindex('Total customers').': <b>'.intval(Tools::getCustomersTotal()).'</b></p>
		<p>'.lindex('Total orders').': <b>'.intval(Tools::getOrdersTotal()).'</b></p>
	</fieldset>

	<br /><br />';

	/* News from PrestaShop website */
	echo '<h2>'.lindex('PrestaShop live!').'</h2>';
	$isoDefault = Language::getIsoById(intval(Configuration::get('PS_LANG_DEFAULT')));
	$isoUser = Language::getIsoById(intval($cookie->id_lang));
	echo'<iframe scrolling="no" frameborder="no" style="margin: 0px; padding: 0px; width: 100%; height: 380px;" src="http://www.prestashop.com/rss/news.php?v='._PS_VERSION_.'&lang='.$isoUser.'"></iframe>';
}

include(PS_ADMIN_DIR.'/footer.inc.php');

?>